/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Slider;
import net.minecraft.util.EnumFacing;

public class PanelScrollBar
extends Slider {
    public final Panel panel;
    private int elementSize;
    private double scrollStep;

    public PanelScrollBar(int x, int y, int w, int h, int ss, Panel p) {
        super(x, y, w, h, ss);
        this.panel = p;
    }

    public void setElementSize(int s) {
        this.elementSize = s;
        if (this.panel.widgets.isEmpty()) {
            this.setScrollStep(0.0);
        } else {
            this.setSrollStepFromOneElementSize(this.elementSize / this.panel.widgets.size());
        }
    }

    public void setScrollStep(double v) {
        this.scrollStep = v;
    }

    public void setSrollStepFromOneElementSize(int s) {
        this.setScrollStep((double)s / (double)(this.elementSize - (this.getPlane() == EnumFacing.Plane.VERTICAL ? this.panel.height : this.panel.width)));
    }

    @Override
    public boolean canMouseScroll(GuiBase gui) {
        return super.canMouseScroll(gui) || gui.isMouseOver(this.panel);
    }

    @Override
    public double getScrollStep() {
        return this.scrollStep;
    }

    @Override
    public void onMoved(GuiBase gui) {
        if (this.getPlane() == EnumFacing.Plane.VERTICAL) {
            this.panel.setScrollY(this.getValue(gui), this.elementSize);
        } else {
            this.panel.setScrollX(this.getValue(gui), this.elementSize);
        }
    }

    @Override
    public boolean isEnabled(GuiBase gui) {
        return this.elementSize > (this.getPlane() == EnumFacing.Plane.VERTICAL ? this.panel.height : this.panel.width);
    }

    @Override
    public boolean shouldRender(GuiBase gui) {
        return this.isEnabled(gui);
    }
}

