/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.TextField;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;

public class ExtendedTextField
extends TextField {
    public final ITextComponent textComponent;
    private List<GuiHelper.PositionedTextData> textData;

    public ExtendedTextField(int x, int y, int width, int height, FontRenderer font, ITextComponent t) {
        super(x, y, width, height, font, t.func_150254_d());
        this.textComponent = t;
        this.textData = GuiHelper.createDataFrom(t, font, width);
    }

    @Nullable
    private GuiHelper.PositionedTextData getDataAtMouse(GuiBase gui) {
        int ax = this.getAX();
        int ay = this.getAY();
        for (GuiHelper.PositionedTextData data : this.textData) {
            if (!gui.isMouseOver(data.posX + ax, data.posY + ay, data.width, data.height)) continue;
            return data;
        }
        return null;
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        GuiHelper.PositionedTextData data = this.getDataAtMouse(gui);
        if (data != null && data.hoverEvent != null) {
            Collections.addAll(list, data.hoverEvent.func_150702_b().func_150254_d().split("\n"));
        }
    }

    @Override
    public void onClicked(GuiBase gui, IMouseButton button) {
        GuiHelper.PositionedTextData data = this.getDataAtMouse(gui);
        if (data != null && data.clickEvent != null && GuiHelper.onClickEvent(data.clickEvent)) {
            GuiHelper.playClickSound();
        }
    }
}

