/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.renderer.GlStateManager;

public class TexturelessRectangle
implements IDrawableObject {
    public final Color4I color;
    public final Color4I lineColor;
    public boolean roundEdges = false;

    public TexturelessRectangle(Color4I col) {
        this.color = new Color4I(true, col);
        this.lineColor = new Color4I(true, Color4I.NONE);
    }

    public TexturelessRectangle setLineColor(Color4I col) {
        this.lineColor.set(col);
        return this;
    }

    public TexturelessRectangle setRoundEdges(boolean v) {
        this.roundEdges = v;
        return this;
    }

    public TexturelessRectangle copy() {
        TexturelessRectangle t = new TexturelessRectangle(this.color);
        t.lineColor.set(this.lineColor);
        t.roundEdges = this.roundEdges;
        return t;
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        Color4I c;
        Color4I color4I = c = col.hasColor() ? col : this.color;
        if (this.roundEdges || this.lineColor.hasColor()) {
            if (c.hasColor()) {
                GuiHelper.drawBlankRect(x + 1, y + 1, w - 2, h - 2, c);
            }
            GuiHelper.drawHollowRect(x, y, w, h, this.lineColor.hasColor() ? this.lineColor : c, this.roundEdges);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (c.hasColor()) {
            GuiHelper.drawBlankRect(x, y, w, h, c);
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("rect"));
        if (this.color.hasColor()) {
            o.add("color", ColorUtils.serialize(this.color.rgba()));
            if (this.color.alpha() != 255) {
                o.add("color_alpha", (JsonElement)new JsonPrimitive((Number)this.color.alpha()));
            }
        }
        if (this.lineColor.hasColor()) {
            o.add("line_color", ColorUtils.serialize(this.lineColor.rgba()));
            if (this.lineColor.alpha() != 255) {
                o.add("line_color_alpha", (JsonElement)new JsonPrimitive((Number)this.lineColor.alpha()));
            }
        }
        if (this.roundEdges) {
            o.add("round_edges", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return o;
    }
}

