/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.lib.client.IPixelBuffer;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.annotation.Nullable;

public class PixelBuffer
implements IPixelBuffer {
    private final int width;
    private final int height;
    private final int[] pixels;

    public PixelBuffer(int w, int h) {
        this.width = w;
        this.height = h;
        this.pixels = new int[w * h];
    }

    public PixelBuffer(BufferedImage img) {
        this(img.getWidth(), img.getHeight());
        this.loadFrom(img);
    }

    public void loadFrom(BufferedImage img) {
        img.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int[] getPixels() {
        return this.pixels;
    }

    @Override
    public void setPixels(int[] p) {
        if (p.length == this.pixels.length) {
            System.arraycopy(p, 0, this.pixels, 0, this.pixels.length);
        }
    }

    @Override
    public void setRGB(int x, int y, int col) {
        this.pixels[x + y * this.width] = col;
    }

    @Override
    public int getRGB(int x, int y) {
        return this.pixels[x + y * this.width];
    }

    @Override
    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray) {
        int off = -1;
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, rgbArray[++off]);
            }
        }
    }

    @Override
    public void setRGB(int startX, int startY, IPixelBuffer buffer) {
        this.setRGB(startX, startY, buffer.getWidth(), buffer.getHeight(), buffer.getPixels());
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h, @Nullable int[] p) {
        if (p == null || p.length != w * h) {
            p = new int[w * h];
        }
        int off = -1;
        w += startX;
        h += startY;
        for (int y = startY; y < h; ++y) {
            for (int x = startX; x < w; ++x) {
                p[++off] = this.getRGB(x, y);
            }
        }
        return p;
    }

    @Override
    public BufferedImage toImage(int type) {
        BufferedImage image = new BufferedImage(this.width, this.height, type);
        image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        return image;
    }

    public void fill(int col) {
        Arrays.fill(this.pixels, col);
    }

    public void fill(int startX, int startY, int w, int h, int col) {
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, col);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PixelBuffer) {
            PixelBuffer b = (PixelBuffer)o;
            if (this.width == b.width && this.height == b.height) {
                for (int i = 0; i < this.pixels.length; ++i) {
                    if (this.pixels[i] == b.pixels[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getPixels());
    }

    public PixelBuffer copy() {
        PixelBuffer b = new PixelBuffer(this.width, this.height);
        System.arraycopy(this.pixels, 0, b.pixels, 0, this.pixels.length);
        return b;
    }

    @Override
    public IPixelBuffer getSubimage(int x, int y, int w, int h) {
        PixelBuffer b = new PixelBuffer(w, h);
        this.getRGB(x, y, w, h, b.pixels);
        return b;
    }

    public void addHSB(float h, float s, float b) {
        ColorUtils.addHSB(this.pixels, h, s, b);
    }
}

