/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.client.teamsgui.GuiCreateTeam;
import com.feed_the_beast.ftbl.client.teamsgui.PublicTeamData;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.PlayerHeadImage;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import java.util.Collections;
import java.util.List;

public class GuiSelectTeam
extends GuiBase {
    private final Panel panelTeams;
    private final PanelScrollBar scrollTeams;

    public GuiSelectTeam(final List<PublicTeamData> teams) {
        super(192, 170);
        Collections.sort(teams);
        this.panelTeams = new Panel(0, 1, 168, 168){

            @Override
            public void addWidgets() {
                this.add(new ButtonCreateTeam());
                for (PublicTeamData t : teams) {
                    this.add(new ButtonTeam(t));
                }
            }

            @Override
            public void updateWidgetPositions() {
                int size = 8;
                int x = 0;
                for (Widget widget : this.widgets) {
                    widget.setX(8 + x * 40);
                    widget.setY(size);
                    if (++x != 4) continue;
                    x = 0;
                    size += 40;
                }
                GuiSelectTeam.this.scrollTeams.setElementSize(size);
            }
        };
        this.panelTeams.addFlags(3);
        this.scrollTeams = new PanelScrollBar(168, 8, 16, 152, 10, this.panelTeams){

            @Override
            public boolean shouldRender(GuiBase gui) {
                return true;
            }
        };
        this.scrollTeams.background = Button.DEFAULT_BACKGROUND;
    }

    @Override
    public void addWidgets() {
        this.add(this.panelTeams);
        this.add(this.scrollTeams);
    }

    @Override
    public IDrawableObject getIcon(GuiBase gui) {
        return DEFAULT_BACKGROUND;
    }

    private static class ButtonTeam
    extends Button {
        private final PublicTeamData team;
        private final IDrawableObject background;
        private static final Color4I INVITED_COLOR = new Color4I(false, 1713414955);

        private ButtonTeam(PublicTeamData t) {
            super(0, 0, 32, 32);
            this.team = t;
            this.setTitle(this.team.color.getTextFormatting() + this.team.displayName);
            this.setIcon(new PlayerHeadImage(t.ownerName));
            this.background = new TexturelessRectangle(this.team.isInvited ? INVITED_COLOR : Color4I.NONE).setLineColor(this.team.color.getColor()).setRoundEdges(true);
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (this.team.isInvited) {
                FTBLibClient.execClientCommand("/ftb team join " + this.team.func_176610_l());
            } else {
                FTBLibClient.execClientCommand("/ftb team request_invite " + this.team.func_176610_l());
            }
            gui.closeGui();
        }

        @Override
        public void renderWidget(GuiBase gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            this.background.draw(ax, ay, 32, 32, Color4I.NONE);
            this.getIcon(gui).draw(ax + 8, ay + 8, 16, 16, Color4I.NONE);
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            list.add(this.getTitle(gui));
            list.add("ID: " + this.team.func_176610_l());
            if (!this.team.description.isEmpty()) {
                list.add("");
                list.add(this.team.description);
            }
            list.add("");
            list.add("Click to " + (this.team.isInvited ? "join the team" : "request invite to this team"));
        }
    }

    private static class ButtonCreateTeam
    extends Button {
        private final IDrawableObject background;

        private ButtonCreateTeam() {
            super(0, 0, 32, 32);
            this.setTitle("Create a New Team");
            this.setIcon(GuiIcons.ADD);
            this.background = new TexturelessRectangle(Color4I.NONE).setLineColor(Color4I.WHITE).setRoundEdges(true);
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            new GuiCreateTeam().openGui();
        }

        @Override
        public void renderWidget(GuiBase gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            this.background.draw(ax, ay, 32, 32, Color4I.NONE);
            this.getIcon(gui).draw(ax + 8, ay + 8, 16, 16, Color4I.NONE);
        }
    }
}

