/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.IFTBLibClientRegistry;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.config.IConfigFile;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.events.FTBLibClientRegistryEvent;
import com.feed_the_beast.ftbl.api.gui.IGuiProvider;
import com.feed_the_beast.ftbl.api_impl.FTBLibAPI_Impl;
import com.feed_the_beast.ftbl.client.ClientNotifications;
import com.feed_the_beast.ftbl.client.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.client.FTBLibClientEventHandler;
import com.feed_the_beast.ftbl.cmd.CmdFTBC;
import com.feed_the_beast.ftbl.lib.SidebarButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.config.ConfigFile;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.gui.PlayerHeadImage;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.net.MessageBase;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.toposort.TopologicalSort;

public class FTBLibModClient
extends FTBLibModCommon
implements IFTBLibClientRegistry,
IResourceManagerReloadListener {
    private IConfigFile clientConfig;
    private static final Map<String, SidebarButton> SIDEBAR_BUTTON_MAP = new HashMap<String, SidebarButton>();
    private static final List<SidebarButton> SIDEBAR_BUTTONS = new ArrayList<SidebarButton>();
    private static final SidebarButton DBUTTON_BEFORE_ALL = new SidebarButton(new ResourceLocation("before_all"));
    private static final SidebarButton DBUTTON_AFTER_ALL = new SidebarButton(new ResourceLocation("after_all"));
    private static final SidebarButton DBUTTON_BEFORE = new SidebarButton(new ResourceLocation("before"));
    private static final SidebarButton DBUTTON_AFTER = new SidebarButton(new ResourceLocation("after"));
    private static final Map<ResourceLocation, IGuiProvider> GUI_PROVIDERS = new HashMap<ResourceLocation, IGuiProvider>();

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register(FTBLibClientEventHandler.class);
        this.clientConfig = new ConfigFile((ITextComponent)new TextComponentTranslation("sidebar_button.ftbl.settings", new Object[0]), () -> new File(LMUtils.folderLocal, "client_config.json"));
        String group = "ftbl";
        this.addClientConfig(group, "item_ore_names", FTBLibClientConfig.ITEM_ORE_NAMES);
        this.addClientConfig(group, "action_buttons_on_top", FTBLibClientConfig.ACTION_BUTTONS_ON_TOP);
        this.addClientConfig(group, "ignore_nei", FTBLibClientConfig.IGNORE_NEI);
        this.addClientConfig(group, "notifications", FTBLibClientConfig.NOTIFICATIONS);
        group = "ftbl.gui";
        this.addClientConfig(group, "enable_chunk_selector_depth", GuiConfigs.ENABLE_CHUNK_SELECTOR_DEPTH);
        group = "ftbl.gui.info";
        this.addClientConfig(group, "border_width", GuiConfigs.INFO_BORDER_WIDTH).addFlags(8);
        this.addClientConfig(group, "border_height", GuiConfigs.INFO_BORDER_HEIGHT).addFlags(8);
        this.addClientConfig(group, "color_background", GuiConfigs.INFO_BACKGROUND);
        this.addClientConfig(group, "color_text", GuiConfigs.INFO_TEXT);
        MinecraftForge.EVENT_BUS.post((Event)new FTBLibClientRegistryEvent(this));
        GameProfile profile = Minecraft.func_71410_x().func_110432_I().func_148256_e();
        if (profile.getId().equals(StringUtils.fromString("5afb9a5b207d480e887967bc848f9a8f"))) {
            LMUtils.userIsLatvianModder = true;
        }
        FTBLibClient.localPlayerHead = new PlayerHeadImage(profile.getName());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager manager) {
        SIDEBAR_BUTTON_MAP.clear();
        this.clientConfig.getTree().entrySet().removeIf(entry -> ((IConfigKey)entry.getKey()).getGroup().equals("sidebar_button"));
        for (Object domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation((String)domain, "sidebar_buttons.json"))) {
                    JsonElement json = JsonUtils.fromJson(new InputStreamReader(resource.func_110527_b()));
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry2 : json.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry2.getValue()).isJsonObject()) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation((String)domain, (String)entry2.getKey()), ((JsonElement)entry2.getValue()).getAsJsonObject());
                        if (button.devOnly && !LMUtils.DEV_ENV) continue;
                        SIDEBAR_BUTTON_MAP.put(button.func_176610_l(), button);
                        if (button.config == null) continue;
                        ConfigKey key = new ConfigKey(button.func_176610_l(), button.config.copy());
                        key.setGroup("sidebar_button");
                        key.setNameLangKey("sidebar_button." + key.func_176610_l());
                        key.setInfoLangKey("sidebar_button." + key.func_176610_l() + ".info");
                        this.clientConfig.add(key, button.config);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        TopologicalSort.DirectedGraph sidebarButtonGraph = new TopologicalSort.DirectedGraph();
        sidebarButtonGraph.addNode((Object)DBUTTON_BEFORE_ALL);
        sidebarButtonGraph.addNode((Object)DBUTTON_BEFORE);
        sidebarButtonGraph.addNode((Object)DBUTTON_AFTER_ALL);
        sidebarButtonGraph.addNode((Object)DBUTTON_AFTER);
        sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)DBUTTON_AFTER);
        sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE_ALL, (Object)DBUTTON_BEFORE);
        sidebarButtonGraph.addEdge((Object)DBUTTON_AFTER, (Object)DBUTTON_AFTER_ALL);
        SIDEBAR_BUTTON_MAP.values().forEach(arg_0 -> ((TopologicalSort.DirectedGraph)sidebarButtonGraph).addNode(arg_0));
        for (SidebarButton button : SIDEBAR_BUTTON_MAP.values()) {
            boolean preDepAdded = false;
            boolean postDepAdded = false;
            for (Map.Entry entry3 : button.dependencies.entrySet()) {
                if (((Boolean)entry3.getValue()).booleanValue()) {
                    for (String id : button.dependencies.keySet()) {
                        postDepAdded = true;
                        if (id.equals("*")) {
                            sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE_ALL, (Object)button);
                            sidebarButtonGraph.addEdge((Object)button, (Object)DBUTTON_BEFORE);
                            preDepAdded = true;
                            continue;
                        }
                        sidebarButtonGraph.addEdge((Object)button, (Object)DBUTTON_AFTER);
                        if (!SIDEBAR_BUTTON_MAP.containsKey(id)) continue;
                        sidebarButtonGraph.addEdge((Object)button, (Object)SIDEBAR_BUTTON_MAP.get(id));
                    }
                    continue;
                }
                preDepAdded = true;
                String id = (String)entry3.getKey();
                if (id.equals("*")) {
                    sidebarButtonGraph.addEdge((Object)button, (Object)DBUTTON_AFTER_ALL);
                    sidebarButtonGraph.addEdge((Object)DBUTTON_AFTER, (Object)button);
                    postDepAdded = true;
                    continue;
                }
                sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)button);
                if (!SIDEBAR_BUTTON_MAP.containsKey(id)) continue;
                sidebarButtonGraph.addEdge((Object)SIDEBAR_BUTTON_MAP.get(id), (Object)button);
            }
            if (!preDepAdded) {
                sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)button);
            }
            if (postDepAdded) continue;
            sidebarButtonGraph.addEdge((Object)button, (Object)DBUTTON_AFTER);
        }
        List sortedSidebarButtonList = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)sidebarButtonGraph);
        sortedSidebarButtonList.removeAll(Arrays.asList(DBUTTON_BEFORE_ALL, DBUTTON_BEFORE, DBUTTON_AFTER, DBUTTON_AFTER_ALL));
        SIDEBAR_BUTTONS.clear();
        SIDEBAR_BUTTONS.addAll(sortedSidebarButtonList);
        this.clientConfig.load();
        this.clientConfig.save();
    }

    @Override
    public void postInit(LoaderState.ModState state) {
        super.postInit(state);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdFTBC());
    }

    @Override
    public void loadAllFiles() {
        super.loadAllFiles();
        this.clientConfig.load();
    }

    @Override
    public void saveAllFiles() {
        super.saveAllFiles();
        this.clientConfig.save();
    }

    @Override
    public IConfigKey addClientConfig(String group, String id, IConfigValue value) {
        ConfigKey key = new ConfigKey(id, value.copy(), group, "client_config");
        this.clientConfig.add(key, value);
        return key;
    }

    @Override
    public void addGui(ResourceLocation id, IGuiProvider provider) {
        GUI_PROVIDERS.put(id, provider);
    }

    @Override
    @Nullable
    public IConfigFile getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public void handleClientMessage(MessageBase<?> message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            message.onMessage((MessageBase)LMUtils.cast(message), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (FTBLibAPI_Impl.LOG_NET) {
                LMUtils.DEV_LOGGER.info("RX MessageBase: " + message.getClass().getName());
            }
        });
    }

    @Override
    public void displayGuide(GuidePage page) {
        new GuiGuide(page).openGui();
    }

    @Override
    public void displayNotification(EnumNotificationDisplay display, INotification n) {
        if (display == EnumNotificationDisplay.SCREEN) {
            ClientNotifications.add(n);
            return;
        }
        List<ITextComponent> list = n.getText();
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            list.get(0).func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, list.get(1)));
        }
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        if (display == EnumNotificationDisplay.CHAT) {
            chat.func_146234_a(list.get(0), n.getId().getChatMessageID());
        } else {
            chat.func_146227_a(list.get(0));
        }
    }

    public static List<SidebarButton> getSidebarButtons(boolean ignoreConfig) {
        if (ignoreConfig) {
            return SIDEBAR_BUTTONS;
        }
        ArrayList<SidebarButton> list = new ArrayList<SidebarButton>();
        for (SidebarButton button : SIDEBAR_BUTTONS) {
            if (!button.isVisible() || button.config != null && !button.config.getBoolean()) continue;
            list.add(button);
        }
        return list;
    }

    @Nullable
    public static IGuiProvider getGui(ResourceLocation id) {
        return GUI_PROVIDERS.get(id);
    }
}

