/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.client.ClientNotifications;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.client.teamsgui.MyTeamData;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.SidebarButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.item.ODItems;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class FTBLibClientEventHandler {
    @SubscribeEvent
    public static void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SharedClientData.INSTANCE.reset();
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Collection<String> ores;
        if (FTBLibClientConfig.ITEM_ORE_NAMES.getBoolean() && !(ores = ODItems.getOreNames(event.getItemStack())).isEmpty()) {
            event.getToolTip().add("Ore Dictionary names:");
            for (String or : ores) {
                event.getToolTip().add("> " + or);
            }
        }
    }

    @SubscribeEvent
    public static void guiInitEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        block8: {
            List<SidebarButton> buttons;
            if (!(event.getGui() instanceof InventoryEffectRenderer) || (buttons = FTBLibModClient.getSidebarButtons(false)).isEmpty()) break block8;
            ButtonInvLMRenderer renderer = new ButtonInvLMRenderer(495830);
            event.getButtonList().add(renderer);
            if (!LMUtils.isNEILoaded() && FTBLibClientConfig.ACTION_BUTTONS_ON_TOP.getBoolean()) {
                int i = 0;
                for (SidebarButton button : buttons) {
                    int x = i % 4;
                    int y = i / 4;
                    ButtonInvLM b = new ButtonInvLM(495830 + i, button, 4 + x * 18, 4 + y * 18);
                    event.getButtonList().add(b);
                    renderer.buttons.add(b);
                    ++i;
                }
            } else {
                boolean hasPotions;
                int xSize = 176;
                int ySize = 166;
                int buttonX = -17;
                int buttonY = 8;
                if (event.getGui() instanceof GuiContainerCreative) {
                    xSize = 195;
                    ySize = 136;
                    buttonY = 6;
                }
                boolean bl = hasPotions = !event.getGui().field_146297_k.field_71439_g.func_70651_bq().isEmpty();
                if (hasPotions) {
                    buttonX -= 4;
                    buttonY -= 26;
                }
                int guiLeft = (event.getGui().field_146294_l - xSize) / 2;
                int guiTop = (event.getGui().field_146295_m - ySize) / 2;
                int i = 0;
                for (SidebarButton button : buttons) {
                    ButtonInvLM b;
                    int y;
                    int x;
                    if (hasPotions) {
                        x = i % 8;
                        y = i / 8;
                        b = new ButtonInvLM(495830 + i, button, guiLeft + buttonX - 18 * x, guiTop + buttonY - y * 18);
                    } else {
                        x = i / 8;
                        y = i % 8;
                        b = new ButtonInvLM(495830 + i, button, guiLeft + buttonX - 18 * x, guiTop + buttonY + 18 * y);
                    }
                    event.getButtonList().add(b);
                    renderer.buttons.add(b);
                    ++i;
                }
            }
        }
    }

    @SubscribeEvent
    public static void guiActionEvent(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof ButtonInvLM) {
            GuiHelper.playClickSound();
            ((ButtonInvLM)event.getButton()).button.onClicked(MouseButton.LEFT);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderGui(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && ClientNotifications.shouldRenderTemp()) {
            ClientNotifications.renderTemp(new ScaledResolution(mc));
        }
    }

    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        FTBLibClient.updateRenderInfo();
    }

    private static class ButtonInvLMRenderer
    extends GuiButton {
        public final List<ButtonInvLM> buttons = new ArrayList<ButtonInvLM>();

        public ButtonInvLMRenderer(int id) {
            super(id, -1000, -1000, 0, 0, "");
        }

        public void func_146112_a(Minecraft mc, int mx, int my) {
            this.field_73735_i = 0.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (ButtonInvLM b : this.buttons) {
                b.button.icon.draw(b.field_146128_h, b.field_146129_i, b.field_146120_f, b.field_146121_g, Color4I.NONE);
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                GuiHelper.drawBlankRect(b.field_146128_h, b.field_146129_i, b.field_146120_f, b.field_146121_g, Color4I.WHITE_A33);
            }
            for (ButtonInvLM b : this.buttons) {
                if (b.renderMessages && MyTeamData.unreadMessages > 0) {
                    String n = String.valueOf(MyTeamData.unreadMessages);
                    int nw = mc.field_71466_p.func_78256_a(n);
                    int width = 16;
                    GuiHelper.drawBlankRect(b.field_146128_h + width - nw, b.field_146129_i - 4, nw + 1, 9, Color4I.LIGHT_RED);
                    mc.field_71466_p.func_78276_b(n, b.field_146128_h + width - nw + 1, b.field_146129_i - 3, -1);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                GlStateManager.func_179094_E();
                double mx1 = (double)mx - 4.0;
                double my1 = (double)my - 12.0;
                int tw = mc.field_71466_p.func_78256_a(b.title);
                if (LMUtils.isNEILoaded() || !FTBLibClientConfig.ACTION_BUTTONS_ON_TOP.getBoolean()) {
                    mx1 -= (double)(tw + 8);
                    my1 += 4.0;
                }
                if (mx1 < 4.0) {
                    mx1 = 4.0;
                }
                if (my1 < 4.0) {
                    my1 = 4.0;
                }
                GlStateManager.func_179137_b((double)mx1, (double)my1, (double)this.field_73735_i);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GuiHelper.drawBlankRect(-3, -2, tw + 6, 12, Color4I.DARK_GRAY);
                mc.field_71466_p.func_78276_b(b.title, 0, 0, -1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static class ButtonInvLM
    extends GuiButton {
        public final SidebarButton button;
        public final String title;
        public final boolean renderMessages;

        public ButtonInvLM(int id, SidebarButton b, int x, int y) {
            super(id, x, y, 16, 16, "");
            this.button = b;
            this.title = StringUtils.translate("sidebar_button." + b.func_176610_l());
            this.renderMessages = b.func_176610_l().equals("ftbl.teams_gui");
        }

        public void func_146112_a(Minecraft mc, int mx, int my) {
        }
    }
}

