/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.api.events.ClientGuideEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api.guide.GuideType;
import com.feed_the_beast.ftbl.api_impl.ForgePlayer;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.lib.SidebarButton;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.guide.GuideTitlePage;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.mercurius.binding.StatsCollectionEvent;

public class FTBLibEventHandler {
    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != 0 || !(event.getWorld() instanceof WorldServer)) {
            return;
        }
        try {
            JsonUtils.toJson(new File(LMUtils.folderWorld, "world_data.json"), SharedServerData.INSTANCE.func_151003_a());
            Universe.INSTANCE.save(new File(LMUtils.folderWorld, "data/ftb_lib"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="mercurius")
    public static void onAnalytics(StatsCollectionEvent event) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FTB_PackMode", SharedServerData.INSTANCE.getPackMode().func_176610_l());
        event.addEventData("ftbl", map);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        boolean firstLogin;
        if (!(e.player instanceof EntityPlayerMP) || Universe.INSTANCE == null) {
            return;
        }
        EntityPlayerMP ep = (EntityPlayerMP)e.player;
        ForgePlayer p = Universe.INSTANCE.getPlayer(ep);
        boolean bl = firstLogin = p == null;
        if (firstLogin) {
            p = new ForgePlayer(ep.func_146103_bH().getId(), ep.func_146103_bH().getName());
            Universe.INSTANCE.playerMap.put(p.getId(), p);
        } else if (!p.getName().equals(ep.func_70005_c_())) {
            p.setUsername(ep.func_146103_bH().getName());
        }
        p.onLoggedIn(ep, firstLogin);
        if (firstLogin && FTBLibConfig.AUTOCREATE_TEAMS.getBoolean()) {
            String id = p.getName().toLowerCase();
            if (Universe.INSTANCE.getTeam(id) != null) {
                id = StringUtils.fromUUID(p.getId());
            }
            if (Universe.INSTANCE.getTeam(id) == null) {
                ForgeTeam team = new ForgeTeam(id);
                team.changeOwner(p);
                Universe.INSTANCE.teams.put(team.func_176610_l(), team);
                MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamCreatedEvent(team));
                MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamPlayerJoinedEvent(team, p));
            }
        }
        if (!p.hideTeamNotification() && p.getTeam() == null) {
            TextComponentString c = new TextComponentString("You haven't joined or created a team yet! ");
            TextComponentString b1 = new TextComponentString("[Click Here]");
            b1.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftb team gui"));
            b1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("TeamsGUI")));
            c.func_150257_a((ITextComponent)b1);
            c.func_150258_a(" to open TeamsGUI or ");
            TextComponentString b2 = new TextComponentString("[Click Here]");
            b2.func_150256_b().func_150238_a(TextFormatting.GOLD);
            b2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftb my_settings ftbl.hide_team_notification true"));
            b2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Hide This Message")));
            c.func_150257_a((ITextComponent)b2);
            c.func_150258_a(" to hide this message.");
            ep.func_145747_a((ITextComponent)c);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        ForgePlayer p;
        if (e.player instanceof EntityPlayerMP && Universe.INSTANCE != null && (p = Universe.INSTANCE.getPlayer(e.player)) != null) {
            p.onLoggedOut();
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent e) {
        EntityPlayerMP ep;
        ForgePlayer p;
        if (e.getEntity() instanceof EntityPlayerMP && Universe.INSTANCE != null && (p = Universe.INSTANCE.getPlayer(ep = (EntityPlayerMP)e.getEntity())) != null) {
            p.onDeath(ep, e.getSource());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuideEvent(ClientGuideEvent event) {
        GuideTitlePage page = new GuideTitlePage("sidebar_buttons", GuideType.OTHER, Collections.singletonList("LatvianModder"), Collections.emptyList());
        page.setIcon(ImageProvider.get("ftbl:textures/gui/teams.png"));
        page.setTitle((ITextComponent)new TextComponentTranslation("config_group.sidebar_button.name", new Object[0]));
        for (SidebarButton button : FTBLibModClient.getSidebarButtons(true)) {
            if (!button.isVisible() || !StringUtils.canTranslate("sidebar_button." + button.func_176610_l() + ".info")) continue;
            GuidePage page1 = page.getSub(button.func_176610_l());
            page1.setIcon(button.icon);
            page1.setTitle((ITextComponent)new TextComponentTranslation("sidebar_button." + button.func_176610_l(), new Object[0]));
            page1.println(new TextComponentTranslation("sidebar_button." + button.func_176610_l() + ".info", new Object[0]));
        }
        event.add(page);
    }
}

