/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class SimpleCapabilityProvider<HANDLER>
implements ICapabilitySerializable<NBTBase> {
    private final Capability<HANDLER> capability;
    private final EnumFacing facing;
    private final HANDLER instance;

    public SimpleCapabilityProvider(Capability<HANDLER> capability, @Nullable EnumFacing facing) {
        this(capability, facing, capability.getDefaultInstance());
    }

    public SimpleCapabilityProvider(Capability<HANDLER> capability, @Nullable EnumFacing facing, HANDLER instance) {
        this.capability = capability;
        this.instance = instance;
        this.facing = facing;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == this.getCapability();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == this.getCapability()) {
            return (T)this.getCapability().cast(this.getInstance());
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return this.getCapability().writeNBT(this.getInstance(), this.getFacing());
    }

    public void deserializeNBT(NBTBase nbt) {
        this.getCapability().readNBT(this.getInstance(), this.getFacing(), nbt);
    }

    public final Capability<HANDLER> getCapability() {
        return this.capability;
    }

    @Nullable
    public EnumFacing getFacing() {
        return this.facing;
    }

    public final HANDLER getInstance() {
        return this.instance;
    }
}

