/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.leveling;

import com.thexfactor117.levels.util.RandomCollection;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public enum EnemyLevel {
    DEFAULT(0xFFFFFF, 0.0),
    WEAKENED(0xAAAAAA, 0.15),
    NORMAL(0xFFFFFF, 0.5),
    HARDENED(43520, 0.15),
    SUPERIOR(0x55FFFF, 0.1),
    ELITE(0xAA00AA, 0.07),
    LEGENDARY(0xFFAA00, 0.03);

    private static final EnemyLevel[] LEVELS;
    private static final RandomCollection<EnemyLevel> RANDOM_LEVELS;
    private int color;
    private double weight;

    private EnemyLevel(int color, double weight) {
        this.color = color;
        this.weight = weight;
    }

    public static EnemyLevel getRandomLevel(Random random) {
        return RANDOM_LEVELS.next(random);
    }

    public static EnemyLevel getEnemyLevel(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b("ENEMY_LEVEL") ? LEVELS[nbt.func_74762_e("ENEMY_LEVEL")] : DEFAULT;
    }

    public void setEnemyLevel(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("ENEMY_LEVEL", this.ordinal());
        }
    }

    public int getColor() {
        return this.color;
    }

    public double getWeight() {
        return this.weight;
    }

    static {
        LEVELS = EnemyLevel.values();
        RANDOM_LEVELS = new RandomCollection();
        for (EnemyLevel level : LEVELS) {
            if (!(level.weight > 0.0)) continue;
            RANDOM_LEVELS.add(level.weight, level);
        }
    }
}

