/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.leveling;

import com.thexfactor117.levels.config.Config;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public enum Ability {
    FIRE("weapon", "active", Config.fire, TextFormatting.RED, 0xFF5555, 1, 1.5),
    FROST("weapon", "active", Config.frost, TextFormatting.AQUA, 0x55FFFF, 1, 1.5),
    POISON("weapon", "active", Config.poison, TextFormatting.DARK_GREEN, 43520, 1, 1.5),
    BLOODLUST("weapon", "active", Config.bloodlust, TextFormatting.DARK_RED, 0xAA0000, 2, 1.5),
    CHAINED("weapon", "active", Config.chained, TextFormatting.GRAY, 0xAAAAAA, 3, 1.5),
    VOID("weapon", "active", Config.voida, TextFormatting.DARK_GRAY, 0x555555, 3, 1.0),
    LIGHT("weapon", "passive", Config.light, TextFormatting.YELLOW, 0xFFFF55, 2, 1.0),
    ETHEREAL("weapon", "passive", Config.ethereal, TextFormatting.GREEN, 0x55FF55, 2, 2.0),
    SOUL_BOUND("weapon", "passive", Config.soulBound, TextFormatting.DARK_PURPLE, 0xAA00AA, 3, 1.0),
    MOLTEN("armor", "active", Config.molten, TextFormatting.RED, 0xFF5555, 1, 1.5),
    FROZEN("armor", "active", Config.frozen, TextFormatting.AQUA, 0x55FFFF, 1, 1.5),
    TOXIC("armor", "active", Config.toxic, TextFormatting.DARK_GREEN, 43520, 1, 1.5),
    ABSORB("armor", "active", Config.absorb, TextFormatting.GREEN, 0x55FF55, 2, 1.5),
    VOID_ARMOR("armor", "active", Config.voidArmor, TextFormatting.DARK_GRAY, 0x555555, 3, 1.0),
    BEASTIAL("armor", "passive", Config.beastial, TextFormatting.DARK_RED, 0xAA0000, 1, 1.5),
    ENLIGHTENED("armor", "passive", Config.enlightened, TextFormatting.YELLOW, 0xFFFF55, 2, 2.0),
    HARDENED("armor", "passive", Config.hardened, TextFormatting.GRAY, 0xAAAAAA, 2, 1.0),
    SOUL_BOUND_ARMOR("armor", "passive", Config.soulBoundArmor, TextFormatting.DARK_PURPLE, 0xAA00AA, 3, 1.0);

    public static int WEAPON_ABILITIES;
    public static int ARMOR_ABILITIES;
    public static final ArrayList<Ability> WEAPONS;
    public static final ArrayList<Ability> ARMOR;
    private String category;
    private String type;
    private boolean enabled;
    private String color;
    private int hex;
    private int tier;
    private double multiplier;

    private Ability(String category, String type, boolean enabled, Object color, int hex, int tier, double multiplier) {
        this.category = category;
        this.type = type;
        this.enabled = enabled;
        this.color = color.toString();
        this.hex = hex;
        this.tier = tier;
        this.multiplier = multiplier;
    }

    public boolean hasAbility(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74767_n(this.toString());
    }

    public void addAbility(NBTTagCompound nbt, int level) {
        nbt.func_74757_a(this.toString(), true);
        this.setLevel(nbt, level);
    }

    public void removeAbility(NBTTagCompound nbt) {
        nbt.func_82580_o(this.toString());
        nbt.func_82580_o(this.toString() + "_level");
    }

    public void setLevel(NBTTagCompound nbt, int level) {
        if (level <= 3) {
            nbt.func_74768_a(this.toString() + "_level", level);
        }
    }

    public int getLevel(NBTTagCompound nbt) {
        if (nbt != null) {
            return nbt.func_74762_e(this.toString() + "_level");
        }
        return 0;
    }

    public boolean canUpgradeLevel(NBTTagCompound nbt) {
        if (this.getType().equals("active")) {
            return this.getLevel(nbt) < 3;
        }
        return false;
    }

    public double getMultiplier(int level) {
        if (level == 1) {
            return 1.0;
        }
        if (level == 2) {
            return this.multiplier;
        }
        if (level == 3) {
            return this.multiplier + this.multiplier / 2.0;
        }
        return 1.0;
    }

    public int getTier() {
        return this.tier;
    }

    public String getColor() {
        return this.color;
    }

    public int getHex() {
        return this.hex;
    }

    public String getName() {
        return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]);
    }

    public String getName(NBTTagCompound nbt) {
        if (this.getLevel(nbt) == 1) {
            return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]);
        }
        if (this.getLevel(nbt) == 2) {
            return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]) + " II";
        }
        if (this.getLevel(nbt) == 3) {
            return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]) + " III";
        }
        return I18n.func_135052_a((String)("levels.ability." + this.ordinal()), (Object[])new Object[0]);
    }

    public String getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    static {
        WEAPONS = new ArrayList();
        ARMOR = new ArrayList();
        for (int i = 0; i < Ability.values().length; ++i) {
            if (Ability.values()[i].getCategory().equals("weapon") && Ability.values()[i].enabled) {
                WEAPONS.add(Ability.values()[i]);
                ++WEAPON_ABILITIES;
                continue;
            }
            if (!Ability.values()[i].getCategory().equals("armor") || !Ability.values()[i].enabled) continue;
            ARMOR.add(Ability.values()[i]);
            ++ARMOR_ABILITIES;
        }
    }
}

