/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event;

import com.thexfactor117.levels.capabilities.CapabilityEnemyLevel;
import com.thexfactor117.levels.capabilities.IEnemyLevel;
import com.thexfactor117.levels.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventRenderOverlay {
    private final double NAME_VISION_DISTANCE = 32.0;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        EntityMob mob;
        Entity entity = this.getEntityCrosshairOver(event.getPartialTicks(), FMLClientHandler.instance().getClient());
        if (entity != null && entity instanceof EntityMob && entity.field_70170_p.field_72995_K && (mob = (EntityMob)entity).hasCapability(CapabilityEnemyLevel.ENEMY_LEVEL_CAP, null)) {
            IEnemyLevel enemyLevel = (IEnemyLevel)mob.getCapability(CapabilityEnemyLevel.ENEMY_LEVEL_CAP, null);
            String buffer = "Default";
            if (enemyLevel.getEnemyLevel() == 1) {
                buffer = TextFormatting.DARK_GRAY + "Weakened";
            }
            if (enemyLevel.getEnemyLevel() == 2) {
                buffer = TextFormatting.WHITE + "Normal";
            }
            if (enemyLevel.getEnemyLevel() == 3) {
                buffer = TextFormatting.DARK_GREEN + "Hardened";
            }
            if (enemyLevel.getEnemyLevel() == 4) {
                buffer = TextFormatting.AQUA + "Superior";
            }
            if (enemyLevel.getEnemyLevel() == 5) {
                buffer = TextFormatting.DARK_PURPLE + "Elite";
            }
            if (enemyLevel.getEnemyLevel() == 6) {
                buffer = TextFormatting.GOLD + "Legendary";
            }
            ScaledResolution resolution = new ScaledResolution(FMLClientHandler.instance().getClient());
            int screenwidth = resolution.func_78326_a();
            int screenheight = resolution.func_78328_b();
            FontRenderer fontR = FMLClientHandler.instance().getClient().field_71466_p;
            if (Config.stringPosition.equals("default")) {
                fontR.func_78276_b(buffer, screenwidth / 2 - fontR.func_78256_a(buffer) / 2, 10, 0xFFFFFF);
            }
            if (Config.stringPosition.equals("topright")) {
                fontR.func_78276_b(buffer, screenwidth - 10 - fontR.func_78256_a(buffer), 10, 0xFFFFFF);
            }
            if (Config.stringPosition.equals("topleft")) {
                fontR.func_78276_b(buffer, 10, 10, 0xFFFFFF);
            }
            if (Config.stringPosition.equals("bottomright")) {
                fontR.func_78276_b(buffer, screenwidth - 10 - fontR.func_78256_a(buffer), screenheight - 20, 0xFFFFFF);
            }
            if (Config.stringPosition.equals("bottomleft")) {
                fontR.func_78276_b(buffer, 10, screenheight - 20, 0xFFFFFF);
            }
            if (Config.stringPosition.equals("cursor")) {
                fontR.func_78276_b(buffer, screenwidth / 2 - fontR.func_78256_a(buffer) / 2, screenheight / 2 - 15, 0xFFFFFF);
            }
        }
    }

    private Entity getEntityCrosshairOver(float renderTick, Minecraft mc) {
        Entity returnedEntity = null;
        if (mc.func_175606_aa() != null && mc.field_71441_e != null) {
            double reachDistance = 32.0;
            RayTraceResult mopos = mc.func_175606_aa().func_174822_a(reachDistance, renderTick);
            double reachDist2 = reachDistance;
            Vec3d viewEntPositionVec = mc.func_175606_aa().func_174791_d();
            if (mopos != null) {
                reachDist2 = mopos.field_72307_f.func_72436_e(viewEntPositionVec);
            }
            Vec3d viewEntityLookVec = mc.func_175606_aa().func_70676_i(renderTick);
            Vec3d actualReachVector = viewEntPositionVec.func_72441_c(viewEntityLookVec.field_72450_a * reachDistance, viewEntityLookVec.field_72448_b * reachDistance, viewEntityLookVec.field_72449_c * reachDistance);
            float expandBBvalue = 0.0f;
            double lowestDistance = reachDist2;
            Entity pointedEntity = null;
            for (Object obj : mc.field_71441_e.func_72839_b(mc.func_175606_aa(), mc.func_175606_aa().func_174813_aQ().func_72321_a(viewEntityLookVec.field_72450_a * reachDistance, viewEntityLookVec.field_72448_b * reachDistance, viewEntityLookVec.field_72449_c * reachDistance).func_72314_b((double)expandBBvalue, (double)expandBBvalue, (double)expandBBvalue))) {
                double distanceToEnt;
                Entity iterEnt = (Entity)obj;
                if (!iterEnt.func_70067_L()) continue;
                float entBorderSize = iterEnt.func_70111_Y();
                AxisAlignedBB entHitBox = iterEnt.func_174813_aQ().func_72314_b((double)entBorderSize, (double)entBorderSize + 1.5, (double)entBorderSize).func_186666_e(iterEnt.func_174813_aQ().field_72337_e - 1.5);
                RayTraceResult interceptObjectPosition = entHitBox.func_72327_a(viewEntPositionVec, actualReachVector);
                if (entHitBox.func_72318_a(viewEntPositionVec)) {
                    if (!(0.0 < lowestDistance) && lowestDistance != 0.0) continue;
                    pointedEntity = iterEnt;
                    lowestDistance = 0.0;
                    continue;
                }
                if (interceptObjectPosition == null || !((distanceToEnt = viewEntPositionVec.func_72438_d(interceptObjectPosition.field_72307_f)) < lowestDistance) && lowestDistance != 0.0) continue;
                pointedEntity = iterEnt;
                lowestDistance = distanceToEnt;
            }
            if (pointedEntity != null && (lowestDistance < reachDist2 || mopos == null)) {
                returnedEntity = pointedEntity;
            }
        }
        return returnedEntity;
    }
}

