/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event;

import com.thexfactor117.levels.Levels;
import com.thexfactor117.levels.config.Config;
import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.util.NBTHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventLivingHurt {
    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        block4: {
            EntityArrow arrow;
            block6: {
                NBTTagCompound nbt;
                block5: {
                    block3: {
                        NBTTagCompound nbt2;
                        if (!(event.getSource().func_76364_f() instanceof EntityPlayer) || event.getSource().func_76364_f() instanceof FakePlayer) break block3;
                        EntityPlayer player = (EntityPlayer)event.getSource().func_76364_f();
                        EntityLivingBase enemy = event.getEntityLiving();
                        ItemStack stack = player.field_71071_by.func_70448_g();
                        if (stack == null || !(stack.func_77973_b() instanceof ItemSword) && !(stack.func_77973_b() instanceof ItemAxe) || (nbt2 = NBTHelper.loadStackNBT(stack)) == null) break block4;
                        this.updateExperience(nbt2);
                        this.useRarity(event, stack, nbt2);
                        this.useWeaponAbilities(event, player, enemy, nbt2);
                        this.updateLevel(player, stack, nbt2);
                        break block4;
                    }
                    if (!(event.getSource().func_76364_f() instanceof EntityLivingBase) || !(event.getEntityLiving() instanceof EntityPlayer)) break block5;
                    EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                    EntityLivingBase enemy = (EntityLivingBase)event.getSource().func_76364_f();
                    for (ItemStack stack : player.field_71071_by.field_70460_b) {
                        NBTTagCompound nbt3;
                        if (stack == null || !(stack.func_77973_b() instanceof ItemArmor) || (nbt3 = NBTHelper.loadStackNBT(stack)) == null) continue;
                        this.updateExperience(nbt3);
                        this.useRarity(event, stack, nbt3);
                        this.useArmorAbilities(event, player, enemy, nbt3);
                        this.updateLevel(player, stack, nbt3);
                    }
                    break block4;
                }
                if (!(event.getSource().func_76364_f() instanceof EntityArrow)) break block4;
                arrow = (EntityArrow)event.getSource().func_76364_f();
                if (!(arrow.field_70250_c instanceof EntityPlayer)) break block6;
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                EntityLivingBase enemy = event.getEntityLiving();
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack == null || !(stack.func_77973_b() instanceof ItemBow) || (nbt = NBTHelper.loadStackNBT(stack)) == null) break block4;
                this.updateExperience(nbt);
                this.useRarity(event, stack, nbt);
                this.useWeaponAbilities(event, player, enemy, nbt);
                this.updateLevel(player, stack, nbt);
                break block4;
            }
            if (arrow.field_70250_c instanceof EntityLivingBase && event.getEntityLiving() instanceof EntityPlayer) {
                EntityLivingBase enemy = (EntityLivingBase)arrow.field_70250_c;
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                for (ItemStack stack : player.field_71071_by.field_70460_b) {
                    NBTTagCompound nbt;
                    if (stack == null || !(stack.func_77973_b() instanceof ItemArmor) || (nbt = NBTHelper.loadStackNBT(stack)) == null) continue;
                    this.updateExperience(nbt);
                    this.useRarity(event, stack, nbt);
                    this.useArmorAbilities(event, player, enemy, nbt);
                    this.updateLevel(player, stack, nbt);
                }
            }
        }
    }

    private void updateExperience(NBTTagCompound nbt) {
        if (Experience.getLevel(nbt) < Config.maxLevel) {
            boolean isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            if (isDev) {
                Experience.setExperience(nbt, Experience.getExperience(nbt) + 1000);
            } else {
                Experience.setExperience(nbt, Experience.getExperience(nbt) + 1);
            }
        }
    }

    private void useRarity(LivingHurtEvent event, ItemStack stack, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        double damageMultiplier = 1.0;
        if (rarity != Rarity.DEFAULT) {
            switch (rarity) {
                case UNCOMMON: {
                    int var = (int)(Math.random() * 20.0);
                    int var1 = (int)(Math.random() * 20.0);
                    int var2 = (int)(Math.random() * 1.0);
                    if (var == 0) {
                        damageMultiplier = Config.uncommonDamage;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 20.0);
                    int var4 = (int)(Math.random() * 1.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case RARE: {
                    int var = (int)(Math.random() * 13.0);
                    int var1 = (int)(Math.random() * 13.0);
                    int var2 = (int)(Math.random() * 2.0);
                    if (var == 0) {
                        damageMultiplier = Config.rareDamage;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 13.0);
                    int var4 = (int)(Math.random() * 2.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case ULTRA_RARE: {
                    int var = (int)(Math.random() * 10.0);
                    int var1 = (int)(Math.random() * 10.0);
                    int var2 = (int)(Math.random() * 3.0);
                    if (var == 0) {
                        damageMultiplier = Config.ultraRareDamage;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 10.0);
                    int var4 = (int)(Math.random() * 3.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case LEGENDARY: {
                    int var = (int)(Math.random() * 7.0);
                    int var1 = (int)(Math.random() * 7.0);
                    int var2 = (int)(Math.random() * 5.0);
                    if (var == 0) {
                        damageMultiplier = Config.legendaryDamage;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 7.0);
                    int var4 = (int)(Math.random() * 5.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
                case ARCHAIC: {
                    int var = (int)(Math.random() * 5.0);
                    int var1 = (int)(Math.random() * 5.0);
                    int var2 = (int)(Math.random() * 10.0);
                    if (var == 0) {
                        damageMultiplier = Config.archaicDamage;
                    }
                    if (var1 == 0) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + var2);
                    }
                    int var3 = (int)(Math.random() * 5.0);
                    int var4 = (int)(Math.random() * 10.0);
                    if (var3 != 0) break;
                    stack.func_77964_b(stack.func_77952_i() - var4);
                    break;
                }
            }
            Levels.LOGGER.info("Amount: " + event.getAmount());
            if (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe) {
                event.setAmount((float)((double)event.getAmount() * damageMultiplier));
            } else if (stack.func_77973_b() instanceof ItemArmor) {
                event.setAmount((float)((double)event.getAmount() / damageMultiplier));
            }
            Levels.LOGGER.info("Amount After: " + event.getAmount());
        }
    }

    private void useWeaponAbilities(LivingHurtEvent event, EntityPlayer player, EntityLivingBase enemy, NBTTagCompound nbt) {
        if (enemy != null) {
            double multiplier;
            if (Ability.FIRE.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.FIRE.getMultiplier(Ability.FIRE.getLevel(nbt));
                enemy.func_70015_d((int)(4.0 * multiplier));
            }
            if (Ability.FROST.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.FROST.getMultiplier(Ability.FROST.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 * (2.0 * multiplier)), 10));
            }
            if (Ability.POISON.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.POISON.getMultiplier(Ability.POISON.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)(20.0 * (7.0 * multiplier)), Ability.POISON.getLevel(nbt)));
            }
            if (Ability.BLOODLUST.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                multiplier = Ability.BLOODLUST.getMultiplier(Ability.BLOODLUST.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_82731_v, (int)(20.0 * (4.0 * multiplier)), Ability.BLOODLUST.getLevel(nbt)));
            }
            if (Ability.CHAINED.hasAbility(nbt) && (int)(Math.random() * 10.0) == 0) {
                multiplier = Ability.CHAINED.getMultiplier(Ability.CHAINED.getLevel(nbt));
                double radius = 10.0 * multiplier;
                World world = enemy.func_130014_f_();
                List entityList = world.func_72872_a(EntityMob.class, new AxisAlignedBB(player.field_70165_t - radius, player.field_70163_u - radius, player.field_70161_v - radius, player.field_70165_t + radius, player.field_70163_u + radius, player.field_70161_v + radius));
                for (Entity entity : entityList) {
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer || entity instanceof EntityAnimal) continue;
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), event.getAmount());
                }
            }
            if (Ability.VOID.hasAbility(nbt) && (int)(Math.random() * 20.0) == 0) {
                float multiplier2 = 0.0f;
                if (Ability.VOID.getLevel(nbt) == 1) {
                    multiplier2 = 0.4f;
                } else if (Ability.VOID.getLevel(nbt) == 2) {
                    multiplier2 = 0.6f;
                } else if (Ability.VOID.getLevel(nbt) == 3) {
                    multiplier2 = 0.8f;
                }
                float damage = enemy.func_110138_aP() * multiplier2;
                event.setAmount(damage);
            }
            if (Ability.LIGHT.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 120, Ability.LIGHT.getLevel(nbt)));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 120, Ability.LIGHT.getLevel(nbt)));
            }
            if (Ability.ETHEREAL.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                float health = player.func_110143_aJ() + event.getAmount() / 2.0f;
                player.func_70606_j(health);
            }
        }
    }

    private void useArmorAbilities(LivingHurtEvent event, EntityPlayer player, EntityLivingBase enemy, NBTTagCompound nbt) {
        if (enemy != null) {
            double multiplier;
            if (Ability.MOLTEN.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.MOLTEN.getMultiplier(Ability.MOLTEN.getLevel(nbt));
                enemy.func_70015_d((int)(4.0 * multiplier));
            }
            if (Ability.FROZEN.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.FROZEN.getMultiplier(Ability.FROZEN.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 * (2.0 * multiplier)), 10));
            }
            if (Ability.TOXIC.hasAbility(nbt) && (int)(Math.random() * 4.0) == 0) {
                multiplier = Ability.TOXIC.getMultiplier(Ability.TOXIC.getLevel(nbt));
                enemy.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)(20.0 * (7.0 * multiplier)), Ability.TOXIC.getLevel(nbt)));
            }
            if (Ability.ABSORB.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                multiplier = Ability.ABSORB.getMultiplier(Ability.ABSORB.getLevel(nbt));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, (int)(20.0 * (5.0 * multiplier)), Ability.ABSORB.getLevel(nbt)));
            }
            if (Ability.VOID.hasAbility(nbt) && (int)(Math.random() * 20.0) == 0) {
                float multiplier2 = 0.0f;
                if (Ability.VOID.getLevel(nbt) == 1) {
                    multiplier2 = 0.4f;
                } else if (Ability.VOID.getLevel(nbt) == 2) {
                    multiplier2 = 0.6f;
                } else if (Ability.VOID.getLevel(nbt) == 3) {
                    multiplier2 = 0.8f;
                }
                float damage = enemy.func_110138_aP() * multiplier2;
                event.setAmount(damage);
            }
            if (Ability.BEASTIAL.hasAbility(nbt) && player.func_110143_aJ() <= player.func_110138_aP() * 0.2f) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
            }
            if (Ability.ENLIGHTENED.hasAbility(nbt) && (int)(Math.random() * 7.0) == 0) {
                float health = player.func_110143_aJ() + event.getAmount() / 2.0f;
                player.func_70606_j(health);
            }
            if (Ability.HARDENED.hasAbility(nbt) && (int)(Math.random() * 10.0) == 0) {
                event.setAmount(0.0f);
            }
        }
    }

    private void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

