/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event;

import com.thexfactor117.levels.capabilities.CapabilityEnemyLevel;
import com.thexfactor117.levels.capabilities.IEnemyLevel;
import com.thexfactor117.levels.config.Config;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.util.NBTHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventLivingDeath {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76364_f() instanceof EntityPlayer && !(event.getSource().func_76364_f() instanceof FakePlayer)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76364_f();
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe) && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                this.addBonusExperience(event, nbt);
                this.updateLevel(player, stack, nbt);
                NBTHelper.saveStackNBT(stack, nbt);
            }
        } else if (event.getSource().func_76364_f() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getSource().func_76364_f();
            if (arrow.field_70250_c instanceof EntityPlayer) {
                NBTTagCompound nbt;
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack != null && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                    this.addBonusExperience(event, nbt);
                    this.updateLevel(player, stack, nbt);
                }
            }
        }
    }

    private void addBonusExperience(LivingDeathEvent event, NBTTagCompound nbt) {
        if (Experience.getLevel(nbt) < Config.maxLevel && event.getEntityLiving() instanceof EntityLivingBase) {
            EntityLivingBase enemy = event.getEntityLiving();
            IEnemyLevel enemyLevel = (IEnemyLevel)enemy.getCapability(CapabilityEnemyLevel.ENEMY_LEVEL_CAP, null);
            int bonusExperience = 0;
            if (enemy.func_110138_aP() <= 10.0f) {
                bonusExperience = 0;
            } else if (enemy.func_110138_aP() > 10.0f && enemy.func_110138_aP() <= 25.0f) {
                bonusExperience = 1;
            } else if (enemy.func_110138_aP() > 25.0f && enemy.func_110138_aP() <= 40.0f) {
                bonusExperience = 2;
            } else if (enemy.func_110138_aP() > 40.0f && enemy.func_110138_aP() <= 75.0f) {
                bonusExperience = 3;
            } else if (enemy.func_110138_aP() > 75.0f) {
                bonusExperience = 4;
            }
            if (enemyLevel != null && enemyLevel.getEnemyLevel() > 0) {
                int level = enemyLevel.getEnemyLevel();
                if (level == 1) {
                    bonusExperience *= 0;
                } else if (level == 2) {
                    bonusExperience *= 1;
                } else if (level == 3) {
                    bonusExperience = (int)((double)bonusExperience * 1.5);
                } else if (level == 4) {
                    bonusExperience *= 2;
                } else if (level == 5) {
                    bonusExperience = (int)((double)bonusExperience * 2.5);
                } else if (level == 6) {
                    bonusExperience *= 3;
                }
            }
            Experience.setExperience(nbt, Experience.getExperience(nbt) + bonusExperience);
        }
    }

    private void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
    }
}

