/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.event;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.config.Config;
import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.util.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EventItemTooltip {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addInformation(ItemTooltipEvent event) {
        NBTTagCompound nbt;
        ArrayList tooltip = (ArrayList)event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item != null && (item instanceof ItemSword || item instanceof ItemAxe || item instanceof ItemArmor || item instanceof ItemBow) && (nbt = NBTHelper.loadStackNBT(stack)) != null && Experience.isEnabled(nbt)) {
            Rarity rarity = Rarity.getRarity(nbt);
            int level = Experience.getLevel(nbt);
            int experience = Experience.getExperience(nbt);
            int maxExperience = Experience.getMaxLevelExp(level);
            this.changeTooltips(tooltip, stack, rarity);
            tooltip.add("");
            tooltip.add(rarity.getColor() + "===============");
            tooltip.add("");
            tooltip.add(rarity.getColor() + TextFormatting.ITALIC + I18n.func_135052_a((String)("levels.rarity." + rarity.ordinal()), (Object[])new Object[0]));
            if (level >= Config.maxLevel) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + level);
            }
            if (level >= Config.maxLevel) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + experience + " / " + maxExperience);
            }
            if (Config.showDurability) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"levels.misc.durability", (Object[])new Object[0]) + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
            }
            tooltip.add("");
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.abilities", (Object[])new Object[0]));
                tooltip.add("");
                if (item instanceof ItemSword || item instanceof ItemAxe || item instanceof ItemBow) {
                    for (Ability ability : Ability.WEAPONS) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add(ability.getColor() + ability.getName(nbt));
                    }
                } else if (item instanceof ItemArmor) {
                    for (Ability ability : Ability.ARMOR) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add(ability.getColor() + ability.getName(nbt));
                    }
                }
            } else {
                tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"levels.misc.abilities.shift", (Object[])new Object[0]));
            }
            tooltip.add("");
            tooltip.add(rarity.getColor() + "===============");
            tooltip.add("");
        }
    }

    private void changeTooltips(ArrayList<String> tooltip, ItemStack stack, Rarity rarity) {
        if (tooltip.indexOf("When in main hand:") != -1) {
            Multimap map = stack.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
            Collection damageCollection = map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            double damage = damageModifier.func_111164_d();
            switch (rarity) {
                case COMMON: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.commonDamage * (damage + 1.0) + ")");
                    break;
                }
                case UNCOMMON: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.uncommonDamage * (damage + 1.0) + ")");
                    break;
                }
                case RARE: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.rareDamage * (damage + 1.0) + ")");
                    break;
                }
                case ULTRA_RARE: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.ultraRareDamage * (damage + 1.0) + ")");
                    break;
                }
                case LEGENDARY: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.legendaryDamage * (damage + 1.0) + ")");
                    break;
                }
                case ARCHAIC: {
                    tooltip.set(tooltip.indexOf("When in main hand:") + 2, tooltip.get(tooltip.indexOf("When in main hand:") + 2) + rarity.getColor() + " (" + Config.archaicDamage * (damage + 1.0) + ")");
                    break;
                }
            }
        }
    }
}

