/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    private static Configuration main;
    private static Configuration abilities;
    private static Configuration rarities;
    public static boolean enemyLeveling;
    public static int maxLevel;
    public static int level1Exp;
    public static double expExponent;
    public static int expMultiplier;
    public static boolean showDurability;
    public static String[] itemBlacklist;
    public static String stringPosition;
    public static int maxAbilities;
    public static boolean fire;
    public static boolean frost;
    public static boolean poison;
    public static boolean bloodlust;
    public static boolean chained;
    public static boolean voida;
    public static boolean light;
    public static boolean ethereal;
    public static boolean soulBound;
    public static boolean molten;
    public static boolean frozen;
    public static boolean toxic;
    public static boolean absorb;
    public static boolean voidArmor;
    public static boolean beastial;
    public static boolean enlightened;
    public static boolean hardened;
    public static boolean soulBoundArmor;
    public static double commonChance;
    public static double uncommonChance;
    public static double rareChance;
    public static double ultraRareChance;
    public static double legendaryChance;
    public static double archaicChance;
    public static double commonDamage;
    public static double uncommonDamage;
    public static double rareDamage;
    public static double ultraRareDamage;
    public static double legendaryDamage;
    public static double archaicDamage;

    public static void init(File dir) {
        main = new Configuration(new File(dir.getPath(), "levels.cfg"));
        abilities = new Configuration(new File(dir.getPath(), "abilities.cfg"));
        rarities = new Configuration(new File(dir.getPath(), "rarities.cfg"));
        Config.sync();
    }

    private static void sync() {
        Config.syncMain();
        Config.syncAbilities();
        Config.syncRarities();
    }

    private static void syncMain() {
        String category = "main";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = main.get(category, "enemyLeveling", enemyLeveling);
        prop.setComment("Determines whether or not Enemy Leveling will be enabled. Default: true");
        enemyLeveling = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = main.get(category, "maxLevel", maxLevel);
        prop.setComment("Sets the maximum level cap for weapons and armor. Default: 7");
        maxLevel = prop.getInt();
        propOrder.add(prop.getName());
        prop = main.get(category, "level1Experience", level1Exp);
        prop.setComment("Sets the amount of experience needed to level up the FIRST time. Default: 50");
        level1Exp = prop.getInt();
        propOrder.add(prop.getName());
        prop = main.get(category, "experienceExponent", expExponent);
        prop.setComment("Sets the exponent of the experience algorithm. Default: 2.4");
        expExponent = prop.getDouble();
        propOrder.add(prop.getName());
        prop = main.get(category, "experienceMultiplier", expMultiplier);
        prop.setComment("Sets the multiplier of the experience algorithm: Default: 20");
        expMultiplier = prop.getInt();
        propOrder.add(prop.getName());
        prop = main.get(category, "showDurabilityInTooltip", showDurability);
        prop.setComment("Determines whether or not durability will be displayed in tooltips. Default: true");
        showDurability = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = main.get(category, "itemBlacklist", itemBlacklist);
        prop.setComment("Items in this blacklist will not gain the leveling systems. Useful for very powerful items or potential conflicts. Style should be 'modid:item'");
        itemBlacklist = prop.getStringList();
        propOrder.add(prop.getName());
        prop = main.get(category, "enemyLevelStringPosition", stringPosition);
        prop.setComment("Determines the location of the enemy level display. Can either be 'default', 'topleft', 'topright', 'bottomleft', 'bottomright', or 'cursor'. Default: 'default'");
        stringPosition = prop.getString();
        propOrder.add(prop.getName());
        main.setCategoryPropertyOrder(category, (List)propOrder);
        main.save();
    }

    private static void syncAbilities() {
        String category = "abilities";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = abilities.get(category, "maxAbilitiesPerItem", maxAbilities);
        prop.setComment("Sets the maximum amount of weapons that can be applied on a given item. Default: 3");
        maxAbilities = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "fireAbility", fire);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        fire = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "frostAbility", frost);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        frost = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "poisonAbility", poison);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        poison = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "bloodlustAbility", bloodlust);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        bloodlust = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "chainedAbility", chained);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        chained = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "voidAbility", voida);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        voida = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "lightAbility", light);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        light = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "etherealAbility", ethereal);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        ethereal = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "soulBoundAbility", soulBound);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        soulBound = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "moltenAbility", molten);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        molten = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "frozenAbility", frozen);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        frozen = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "toxicAbility", toxic);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        toxic = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "absorbAbility", absorb);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        absorb = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "voidArmorAbility", voidArmor);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        voidArmor = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "beastialAbility", beastial);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        beastial = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "enlightenedAbility", enlightened);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        enlightened = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "hardenedAbility", hardened);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        hardened = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "soulBoundArmorAbility", soulBoundArmor);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        soulBoundArmor = prop.getBoolean();
        propOrder.add(prop.getName());
        abilities.setCategoryPropertyOrder(category, (List)propOrder);
        abilities.save();
    }

    private static void syncRarities() {
        String category = "rarities";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = rarities.get(category, "commonChance", commonChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.5");
        commonChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "uncommonChance", uncommonChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.25");
        uncommonChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "rareChance", rareChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.13");
        rareChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ultraRareChance", ultraRareChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.07");
        ultraRareChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "legendaryChance", legendaryChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.035");
        legendaryChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "archaicChance", archaicChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.015");
        archaicChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "commonDamage", commonDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 1");
        commonDamage = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "uncommonDamage", uncommonDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 1.5");
        uncommonDamage = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "rareDamage", rareDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 2");
        rareDamage = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ultraRareDamage", ultraRareDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 2.5");
        ultraRareDamage = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "legendaryDamage", legendaryDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 3");
        legendaryDamage = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "archaicDamage", archaicDamage);
        prop.setComment("Sets the damage multiplier for the given rarity. Default: 4");
        archaicDamage = prop.getDouble();
        propOrder.add(prop.getName());
        rarities.setCategoryPropertyOrder(category, (List)propOrder);
        rarities.save();
    }

    static {
        enemyLeveling = true;
        maxLevel = 7;
        level1Exp = 50;
        expExponent = 2.4f;
        expMultiplier = 20;
        showDurability = true;
        itemBlacklist = new String[]{"modid:item"};
        stringPosition = "default";
        maxAbilities = 3;
        fire = true;
        frost = true;
        poison = true;
        bloodlust = true;
        chained = true;
        voida = true;
        light = true;
        ethereal = true;
        soulBound = true;
        molten = true;
        frozen = true;
        toxic = true;
        absorb = true;
        voidArmor = true;
        beastial = true;
        enlightened = true;
        hardened = true;
        soulBoundArmor = true;
        commonChance = 0.5;
        uncommonChance = 0.25;
        rareChance = 0.13f;
        ultraRareChance = 0.07f;
        legendaryChance = 0.035f;
        archaicChance = 0.015f;
        commonDamage = 1.0;
        uncommonDamage = 1.5;
        rareDamage = 2.0;
        ultraRareDamage = 2.5;
        legendaryDamage = 3.0;
        archaicDamage = 4.0;
    }
}

