/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.client.gui;

import com.thexfactor117.levels.Levels;
import com.thexfactor117.levels.config.Config;
import com.thexfactor117.levels.leveling.Ability;
import com.thexfactor117.levels.leveling.Experience;
import com.thexfactor117.levels.leveling.Rarity;
import com.thexfactor117.levels.network.PacketGuiAbility;
import com.thexfactor117.levels.util.NBTHelper;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiAbilitySelection
extends GuiScreen {
    private GuiButton[] weaponAbilities;
    private GuiButton[] armorAbilities;

    @SideOnly(value=Side.CLIENT)
    public void func_73866_w_() {
        block8: {
            ItemStack stack;
            block9: {
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                if (player == null || (stack = player.field_71071_by.func_70448_g()) == null) break block8;
                if (!(stack.func_77973_b() instanceof ItemSword) && !(stack.func_77973_b() instanceof ItemAxe) && !(stack.func_77973_b() instanceof ItemBow)) break block9;
                this.weaponAbilities = new GuiButton[Ability.WEAPON_ABILITIES];
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) break block8;
                int j = 0;
                for (int i = 0; i < this.weaponAbilities.length; ++i) {
                    if (Ability.WEAPONS.get(i).getType().equals("active")) {
                        this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 200, 100 + i * 20, 75, 20, Ability.WEAPONS.get(i).getName() + " (" + Ability.WEAPONS.get(i).getTier() + ")");
                        ++j;
                    } else {
                        this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 100, 100 + (i - j) * 20, 75, 20, Ability.WEAPONS.get(i).getName() + " (" + Ability.WEAPONS.get(i).getTier() + ")");
                    }
                    this.field_146292_n.add(this.weaponAbilities[i]);
                    this.weaponAbilities[i].field_146124_l = false;
                }
                break block8;
            }
            if (stack.func_77973_b() instanceof ItemArmor) {
                this.armorAbilities = new GuiButton[Ability.ARMOR_ABILITIES];
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null) {
                    int j = 0;
                    for (int i = 0; i < this.armorAbilities.length; ++i) {
                        if (Ability.ARMOR.get(i).getType().equals("active")) {
                            this.armorAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 200, 100 + i * 20, 75, 20, Ability.ARMOR.get(i).getName() + " (" + Ability.ARMOR.get(i).getTier() + ")");
                            ++j;
                        } else {
                            this.armorAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 100, 100 + (i - j) * 20, 75, 20, Ability.ARMOR.get(i).getName() + " (" + Ability.ARMOR.get(i).getTier() + ")");
                        }
                        this.field_146292_n.add(this.armorAbilities[i]);
                        this.armorAbilities[i].field_146124_l = false;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        NBTTagCompound nbt;
        ItemStack stack;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null && (stack = player.field_71071_by.func_70448_g()) != null && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b() instanceof ItemArmor || stack.func_77973_b() instanceof ItemBow) && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
            if (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b() instanceof ItemBow) {
                this.drawStrings(stack, Ability.WEAPONS, nbt);
                this.displayButtons(this.weaponAbilities, Ability.WEAPONS, nbt);
                this.drawTooltips(this.weaponAbilities, Ability.WEAPONS, mouseX, mouseY);
            } else if (stack.func_77973_b() instanceof ItemArmor) {
                this.drawStrings(stack, Ability.ARMOR, nbt);
                this.displayButtons(this.armorAbilities, Ability.ARMOR, nbt);
                this.drawTooltips(this.armorAbilities, Ability.ARMOR, mouseX, mouseY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146284_a(GuiButton button) throws IOException {
        block2: {
            ItemStack stack;
            block3: {
                NBTTagCompound nbt;
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                if (player == null || (stack = player.field_71071_by.func_70448_g()) == null || (nbt = NBTHelper.loadStackNBT(stack)) == null || Experience.getAbilityTokens(nbt) <= 0) break block2;
                if (!(stack.func_77973_b() instanceof ItemSword) && !(stack.func_77973_b() instanceof ItemAxe) && !(stack.func_77973_b() instanceof ItemBow)) break block3;
                for (int i = 0; i < this.weaponAbilities.length; ++i) {
                    if (button != this.weaponAbilities[i]) continue;
                    Levels.network.sendToServer((IMessage)new PacketGuiAbility(i));
                }
                break block2;
            }
            if (!(stack.func_77973_b() instanceof ItemArmor)) break block2;
            for (int i = 0; i < this.armorAbilities.length; ++i) {
                if (button != this.armorAbilities[i]) continue;
                Levels.network.sendToServer((IMessage)new PacketGuiAbility(i));
            }
        }
    }

    private void drawStrings(ItemStack stack, ArrayList<Ability> abilities, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        this.func_73732_a(this.field_146289_q, stack.func_82833_r(), this.field_146294_l / 2, 20, rarity.getHex());
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.rarity", (Object[])new Object[0]) + ": " + rarity.getName(), this.field_146294_l / 2 - 50, 40, rarity.getHex());
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities", (Object[])new Object[0]), this.field_146294_l / 2, 80, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.tokens", (Object[])new Object[0]) + ": " + Experience.getAbilityTokens(nbt), this.field_146294_l / 2 - 112, 85, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.purchased", (Object[])new Object[0]), this.field_146294_l / 2 + 112, 100, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.active", (Object[])new Object[0]), this.field_146294_l / 2 + 75, 120, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.abilities.passive", (Object[])new Object[0]), this.field_146294_l / 2 + 150, 120, 0xFFFFFF);
        if (Experience.getLevel(nbt) == Config.maxLevel) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]), this.field_146294_l / 2 - 50, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"levels.misc.max", (Object[])new Object[0]), this.field_146294_l / 2 - 50, 60, 0xFFFFFF);
        } else {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.level", (Object[])new Object[0]) + ": " + Experience.getLevel(nbt), this.field_146294_l / 2 - 50, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"levels.misc.experience", (Object[])new Object[0]) + ": " + Experience.getExperience(nbt) + " / " + Experience.getMaxLevelExp(Experience.getLevel(nbt)), this.field_146294_l / 2 - 50, 60, 0xFFFFFF);
        }
        int j = -1;
        int k = -1;
        for (int i = 0; i < abilities.size(); ++i) {
            if (!abilities.get(i).hasAbility(nbt)) continue;
            if (abilities.get(i).getType().equals("active")) {
                this.func_73732_a(this.field_146289_q, abilities.get(i).getName(nbt), this.field_146294_l / 2 + 75, 135 + ++j * 10, abilities.get(i).getHex());
                continue;
            }
            this.func_73732_a(this.field_146289_q, abilities.get(i).getName(nbt), this.field_146294_l / 2 + 150, 135 + ++k * 10, abilities.get(i).getHex());
        }
    }

    private void displayButtons(GuiButton[] buttons, ArrayList<Ability> abilities, NBTTagCompound nbt) {
        if (Experience.getAbilityTokens(nbt) > 0) {
            for (int i = 0; i < buttons.length; ++i) {
                if (Experience.getAbilityTokens(nbt) == 1) {
                    if (abilities.get(i).getTier() == 1) {
                        buttons[i].field_146124_l = true;
                    }
                    if (abilities.get(i).hasAbility(nbt) && abilities.get(i).canUpgradeLevel(nbt)) {
                        buttons[i].field_146124_l = true;
                    } else if (abilities.get(i).hasAbility(nbt)) {
                        buttons[i].field_146124_l = false;
                    }
                }
                if (Experience.getAbilityTokens(nbt) == 2) {
                    if (abilities.get(i).getTier() <= 2) {
                        buttons[i].field_146124_l = true;
                    }
                } else {
                    if (abilities.get(i).getTier() == 2) {
                        buttons[i].field_146124_l = false;
                    }
                    if (abilities.get(i).hasAbility(nbt) && abilities.get(i).canUpgradeLevel(nbt)) {
                        buttons[i].field_146124_l = true;
                    } else if (abilities.get(i).hasAbility(nbt)) {
                        buttons[i].field_146124_l = false;
                    }
                }
                if (Experience.getAbilityTokens(nbt) >= 3) {
                    buttons[i].field_146124_l = true;
                    if (abilities.get(i).hasAbility(nbt) && abilities.get(i).canUpgradeLevel(nbt)) {
                        buttons[i].field_146124_l = true;
                    } else if (abilities.get(i).hasAbility(nbt)) {
                        buttons[i].field_146124_l = false;
                    }
                } else {
                    if (abilities.get(i).getTier() == 3) {
                        buttons[i].field_146124_l = false;
                    }
                    if (abilities.get(i).hasAbility(nbt) && abilities.get(i).canUpgradeLevel(nbt)) {
                        buttons[i].field_146124_l = true;
                    } else if (abilities.get(i).hasAbility(nbt)) {
                        buttons[i].field_146124_l = false;
                    }
                }
                if (!abilities.get(i).hasAbility(nbt) || !abilities.get(i).getType().equals("passive")) continue;
                buttons[i].field_146124_l = false;
            }
        } else {
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i].field_146124_l = false;
            }
        }
    }

    private void drawTooltips(GuiButton[] buttons, ArrayList<Ability> abilities, int mouseX, int mouseY) {
        for (int i = 0; i < buttons.length; ++i) {
            HoverChecker checker = new HoverChecker(buttons[i], 0);
            if (!checker.checkHover(mouseX, mouseY)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(abilities.get(i).getColor() + abilities.get(i).getName());
            list.add("");
            list.add(I18n.func_135052_a((String)("levels.abilities.info." + abilities.get(i).ordinal()), (Object[])new Object[0]));
            this.func_146283_a(list, mouseX + 3, mouseY + 3);
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

