/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.capabilities;

import com.thexfactor117.levels.capabilities.EnemyLevel;
import com.thexfactor117.levels.capabilities.IEnemyLevel;
import com.thexfactor117.levels.util.CapabilityUtils;
import com.thexfactor117.levels.util.SimpleCapabilityProvider;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityEnemyLevel {
    @CapabilityInject(value=IEnemyLevel.class)
    public static final Capability<IEnemyLevel> ENEMY_LEVEL_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("levels", "EnemyLevel");

    public static void register() {
        CapabilityManager.INSTANCE.register(IEnemyLevel.class, (Capability.IStorage)new Capability.IStorage<IEnemyLevel>(){

            public NBTBase writeNBT(Capability<IEnemyLevel> capability, IEnemyLevel instance, EnumFacing side) {
                return new NBTTagInt(instance.getEnemyLevel());
            }

            public void readNBT(Capability<IEnemyLevel> capability, IEnemyLevel instance, EnumFacing side, NBTBase nbt) {
                instance.setEnemyLevel(((NBTTagInt)nbt).func_150287_d());
            }
        }, () -> new EnemyLevel(null));
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Nullable
    public static IEnemyLevel getEnemyLevel(EntityLivingBase entity) {
        return CapabilityUtils.getCapability((ICapabilityProvider)entity, ENEMY_LEVEL_CAP, DEFAULT_FACING);
    }

    public static ICapabilityProvider createProvider(IEnemyLevel level) {
        return new SimpleCapabilityProvider<IEnemyLevel>(ENEMY_LEVEL_CAP, DEFAULT_FACING, level);
    }

    public static class EventHandler {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityMob) {
                EnemyLevel enemyLevel = new EnemyLevel((EntityLivingBase)((EntityMob)event.getObject()));
                event.addCapability(ID, CapabilityEnemyLevel.createProvider(enemyLevel));
            }
        }
    }
}

