/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PacketListFromServer<S extends PacketListFromServer, T>
implements IMessage {
    public BlockPos pos;
    public List<T> list;
    public String command;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                T item = this.createItem(buf);
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    protected abstract T createItem(ByteBuf var1);

    protected abstract void writeItemToBuf(ByteBuf var1, T var2);

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (T item : this.list) {
                this.writeItemToBuf(buf, item);
            }
        }
    }

    public PacketListFromServer() {
    }

    public PacketListFromServer(BlockPos pos, String command, List<T> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<T>();
        this.list.addAll(list);
    }
}

