/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderAssist {
    public static float zLevel;
    private static TextureManager manager;
    private static FontRenderer fontObj;
    public static String mcColorUni;
    private static final int BYTES_PER_PIXEL = 4;

    public static void drawUnfilledCircle(float posX, float posY, float radius, int num_segments, int color) {
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        renderer.func_181668_a(2, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < num_segments; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)num_segments;
            double x = (double)radius * Math.cos(theta);
            double y = (double)radius * Math.sin(theta);
            renderer.func_181662_b(x + (double)posX, y + (double)posY, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(float posX, float posY, float radius, int num_segments, int color) {
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        GlStateManager.func_187447_r((int)6);
        GL11.glVertex2f((float)posX, (float)posY);
        for (int i = num_segments; i >= 0; --i) {
            double theta = (double)i * (Math.PI * 2) / (double)num_segments;
            GL11.glVertex2d((double)((double)posX + (double)radius * Math.cos(theta)), (double)((double)posY + (double)radius * Math.sin(theta)));
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawUnfilledRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        vertexbuffer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawHorizontalLine(int par1, int par2, int par3, int par4) {
        if (par2 < par1) {
            int i1 = par1;
            par1 = par2;
            par2 = i1;
        }
        RenderAssist.drawRect(par1, par3, par2 + 1, par3 + 1, par4);
    }

    public static void drawVerticalLine(int par1, int par2, int par3, int par4) {
        if (par3 < par2) {
            int i1 = par2;
            par2 = par3;
            par3 = i1;
        }
        RenderAssist.drawRect(par1, par2 + 1, par1 + 1, par3, par4);
    }

    public static void drawTexturedModalRect(float x, float y, float width, float height) {
        RenderAssist.drawTexturedModalRect(x, y, width, height, 255);
    }

    public static void drawTexturedModalRect(float x, float y, float width, float height, int alpha) {
        float f = (float)alpha / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a((double)((u + 0.0f) * f), (double)((v + height) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((u + width) * f), (double)((v + height) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + width) * f), (double)((v + 0.0f) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + 0.0f) * f), (double)((v + 0.0f) * f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRectCustomSize(float x, float y, float uMin, float vMin, float uMax, float vMax, float width, float height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a((double)((uMin + 0.0f) * f), (double)((vMin + vMax) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((uMin + uMax) * f), (double)((vMin + vMax) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((uMin + uMax) * f), (double)((vMin + 0.0f) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((uMin + 0.0f) * f), (double)((vMin + 0.0f) * f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedFrame(int x, int y, float uMin, float vMin, float uMax, float vMax, float width, float height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0), (double)((float)y + height), (double)zLevel).func_187315_a((double)((uMin + 0.0f) * f), (double)((vMin + vMax) * f)).func_181675_d();
        renderer.func_181662_b((double)((float)x + width), (double)((float)y + height), (double)zLevel).func_187315_a((double)((uMin + uMax) * f), (double)((vMin + vMax) * f)).func_181675_d();
        renderer.func_181662_b((double)((float)x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((uMin + uMax) * f), (double)((vMin + 0.0f) * f)).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((uMin + 0.0f) * f), (double)((vMin + 0.0f) * f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindTexture(ResourceLocation res) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }

    public static void bindTexture(String textureLocation) {
        ResourceLocation res = new ResourceLocation(textureLocation);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
    }

    public static void drawRect(float g, float h, float i, float j, int color) {
        float j1;
        if (g < i) {
            j1 = g;
            g = i;
            i = j1;
        }
        if (h < j) {
            j1 = h;
            h = j;
            j = j1;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)g, (double)j, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)i, (double)j, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)i, (double)h, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)g, (double)h, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getColorFromRGBA_F(float par1, float par2, float par3, float par4) {
        int R = (int)(par1 * 255.0f);
        int G = (int)(par2 * 255.0f);
        int B = (int)(par3 * 255.0f);
        int A = (int)(par4 * 255.0f);
        return RenderAssist.getColorFromRGBA(R, G, B, A);
    }

    public static int getColorFromRGBA(int R, int G, int B, int A) {
        if (R > 255) {
            R = 255;
        }
        if (G > 255) {
            G = 255;
        }
        if (B > 255) {
            B = 255;
        }
        if (A > 255) {
            A = 255;
        }
        if (R < 0) {
            R = 0;
        }
        if (G < 0) {
            G = 0;
        }
        if (B < 0) {
            B = 0;
        }
        if (A < 0) {
            A = 0;
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return A << 24 | R << 16 | G << 8 | B;
        }
        return B << 24 | G << 16 | R << 8 | A;
    }

    public static Color blendColors(int a, int b, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int aA = a >> 24 & 0xFF;
        int aR = (a & 0xFF0000) >> 16;
        int aG = (a & 0xFF00) >> 8;
        int aB = a & 0xFF;
        int bA = b >> 24 & 0xFF;
        int bR = (b & 0xFF0000) >> 16;
        int bG = (b & 0xFF00) >> 8;
        int bB = b & 0xFF;
        int A = (int)((float)aA * iRatio + (float)bA * ratio);
        int R = (int)((float)aR * iRatio + (float)bR * ratio);
        int G = (int)((float)aG * iRatio + (float)bG * ratio);
        int B = (int)((float)aB * iRatio + (float)bB * ratio);
        return new Color(R, G, B, A);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScreenOverlay(int par1, int par2, int par5) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        GL11.glDisable((int)3008);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(0.0, (double)par2, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)par1, (double)par2, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)par1, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void blendTextures(Render renderer, ResourceLocation texture1, ResourceLocation texture2) {
        float partOf1 = 0.5f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        renderer.func_177068_d().field_78724_e.func_110577_a(texture1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.func_177068_d().field_78724_e.func_110577_a(texture2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - partOf1));
    }

    public static void scaledTexturedModalRect(int x, int y, int u, int v, int width, int height, int scale) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height * scale), 0.0).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width * scale), (double)(y + height * scale), 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width * scale), (double)(y + 0), 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderItem(ItemStack stack, int x, int y, float scale) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179121_F();
    }

    public static ResourceLocation ExternalResouceLocation(String src) throws IOException {
        File file = new File(src);
        BufferedImage skinBR = ImageIO.read(file);
        DynamicTexture texture = new DynamicTexture(skinBR);
        ResourceLocation resource = manager.func_110578_a(src, texture);
        return resource;
    }

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    static {
        manager = Minecraft.func_71410_x().func_110434_K();
        fontObj = Minecraft.func_71410_x().field_71466_p;
        mcColorUni = "\u00a74";
    }

    public static enum Alignment {
        TOP_LEFT("top_left"),
        TOP_CENTER("top_center"),
        TOP_RIGHT("top_right"),
        CENTER_LEFT("center_left"),
        CENTER_CENTER("center_center"),
        CENTER_RIGHT("center_right"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_CENTER("bottom_center"),
        BOTTOM_RIGHT("bottom_right");

        String alignment;
        public int x;
        public int y;

        private Alignment(String alignment) {
            this.alignment = alignment;
        }

        public static Alignment getScreenAlignment(Minecraft mc, Alignment alignment, int objWidth, int objHeight) {
            switch (alignment) {
                case TOP_LEFT: {
                    alignment.x = 0;
                    alignment.y = 0;
                    break;
                }
                case TOP_CENTER: {
                    alignment.x = mc.field_71462_r.field_146294_l / 2 - objWidth / 2;
                    alignment.y = 0;
                    break;
                }
                case TOP_RIGHT: {
                    alignment.x = mc.field_71462_r.field_146294_l - objWidth;
                    alignment.y = 0;
                    break;
                }
                case CENTER_LEFT: {
                    alignment.x = 0;
                    alignment.y = mc.field_71462_r.field_146295_m / 2 - objHeight / 2;
                    break;
                }
                case CENTER_CENTER: {
                    alignment.x = mc.field_71462_r.field_146294_l / 2 - objWidth / 2;
                    alignment.y = mc.field_71462_r.field_146295_m / 2 - objHeight / 2;
                    break;
                }
                case CENTER_RIGHT: {
                    alignment.x = mc.field_71462_r.field_146294_l - objWidth;
                    alignment.y = mc.field_71462_r.field_146295_m / 2 - objHeight / 2;
                    break;
                }
                case BOTTOM_LEFT: {
                    alignment.x = 0;
                    alignment.y = mc.field_71462_r.field_146295_m - objHeight;
                    break;
                }
                case BOTTOM_CENTER: {
                    alignment.x = mc.field_71462_r.field_146294_l / 2 - objWidth / 2;
                    alignment.y = mc.field_71462_r.field_146295_m - objHeight;
                    break;
                }
                case BOTTOM_RIGHT: {
                    alignment.x = mc.field_71462_r.field_146294_l - objWidth;
                    alignment.y = mc.field_71462_r.field_146295_m - objHeight;
                }
            }
            return alignment;
        }
    }
}

