/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.handlers;

import com.gendeathrow.pmobs.core.ConfigHandler;
import com.gendeathrow.pmobs.core.PMSettings;
import com.gendeathrow.pmobs.core.RaidersCore;
import com.gendeathrow.pmobs.handlers.RaiderData;
import com.gendeathrow.pmobs.util.Tools;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class RaiderManager {
    public static final HashMap<String, RaiderData> raidersList = new HashMap();
    public static final File raiderFile = new File(ConfigHandler.configDir, "raiders.json");
    public static final File whiteListFolder = new File("raidersWhitelist");
    public static final Random rand = new Random();
    private static boolean markDirty = false;

    public static RaiderData getRandomRaider() {
        return (RaiderData)WeightedRandom.func_76271_a((Random)rand, RaiderManager.getWeightedList());
    }

    private static List<RaiderData> getWeightedList() {
        return Lists.newArrayList(raidersList.values());
    }

    public static GameProfile getRaiderProfile(String ownerName) {
        if (raidersList.containsKey(ownerName)) {
            return raidersList.get(ownerName).getProfile();
        }
        raidersList.put(ownerName, new RaiderData(new GameProfile(null, ownerName), 10));
        return raidersList.get(ownerName).getProfile();
    }

    public static HashMap<String, RaiderData> getAllRaiders() {
        return raidersList;
    }

    public static void setRaiderProfile(String ownerName, GameProfile newProfile) {
        if (raidersList.containsKey(ownerName)) {
            raidersList.get(ownerName).setProfile(newProfile);
        }
    }

    protected static void permanentRaiders() {
        int weight = (int)((double)WeightedRandom.func_76272_a(RaiderManager.getWeightedList()) * 0.01);
        if (!raidersList.containsKey("Herobrine")) {
            raidersList.put("Herobrine", new RaiderData(new GameProfile(null, "Herobrine"), weight < 1 ? 1 : weight));
        }
        if (raidersList.containsKey("Herobrine")) {
            RaiderManager.raidersList.get((Object)"Herobrine").field_76292_a = weight < 1 ? 1 : weight;
            markDirty = true;
        }
    }

    public static void addNewRaider(String ownerName, int weight) {
        if (!raidersList.containsKey(ownerName)) {
            raidersList.put(ownerName, new RaiderData(new GameProfile(null, ownerName), weight));
            markDirty = true;
        }
    }

    public static void removeRaider(String ownerName) {
        raidersList.remove(ownerName);
        markDirty = true;
    }

    public static void Save() {
        if (markDirty) {
            RaiderManager.saveRaiderFile();
            markDirty = false;
        }
    }

    public static void readRaiderFile() {
        RaiderManager.getTwitchSubscribers();
        if (raiderFile.isFile()) {
            try {
                raidersList.clear();
                raidersList.putAll(RaiderManager.parseJson(FileUtils.readFileToString((File)raiderFile)));
                RaiderManager.permanentRaiders();
                RaiderManager.getTwitchSubscribers();
            }
            catch (IOException ioexception) {
                RaidersCore.logger.error("Couldn't read Raiders file " + raiderFile, (Throwable)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                RaidersCore.logger.error("Couldn't parse Raiders file " + raiderFile, (Throwable)jsonparseexception);
            }
        } else {
            RaiderManager.saveRaiderFile();
        }
    }

    public static void saveRaiderFile() {
        FileOutputStream fo = null;
        try {
            fo = FileUtils.openOutputStream((File)raiderFile);
            String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)RaiderManager.dumpJson(raidersList));
            FileUtils.writeStringToFile((File)raiderFile, (String)json);
            fo.close();
        }
        catch (IOException ioexception) {
            RaidersCore.logger.error("Couldn't save stats", (Throwable)ioexception);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fo);
        }
    }

    public static Map<String, RaiderData> parseJson(String p_150881_1_) {
        JsonElement jsonelement = new JsonParser().parse(p_150881_1_);
        if (!jsonelement.isJsonObject()) {
            return Maps.newHashMap();
        }
        JsonObject jsonobject = jsonelement.getAsJsonObject();
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonobject.entrySet()) {
            String playerOwner = (String)entry.getKey();
            if (playerOwner != null) {
                JsonObject playerData = ((JsonElement)entry.getValue()).getAsJsonObject();
                int weight = 10;
                if (playerData.has("weight")) {
                    weight = playerData.get("weight").getAsInt();
                }
                GameProfile playerProfile = new GameProfile((UUID)null, playerOwner);
                RaiderData raiderData = new RaiderData(playerProfile, weight);
                if (!map.containsKey(playerOwner)) {
                    map.put(playerOwner, raiderData);
                    continue;
                }
                RaidersCore.logger.warn("Raider already exist in " + raiderFile + ":" + (String)entry.getKey());
                continue;
            }
            RaidersCore.logger.warn("Invalid Raider in " + raiderFile + ": Don't know what " + (String)entry.getKey() + " is");
        }
        return map;
    }

    public static JsonObject dumpJson(Map<String, RaiderData> p_150880_0_) {
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry<String, RaiderData> entry : p_150880_0_.entrySet()) {
            if (entry.getValue() != null) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("weight", (Number)entry.getValue().field_76292_a);
                jsonobject.add(entry.getKey(), (JsonElement)jsonobject1);
                continue;
            }
            jsonobject.addProperty(entry.getKey(), (Number)10);
        }
        return jsonobject;
    }

    public static void getTwitchSubscribers() {
        RaiderManager.getTwitchSubscribers(false);
    }

    public static void getTwitchSubscribers(boolean force) {
        whiteListFolder.mkdirs();
        for (String list : PMSettings.whitelists) {
            File subs = new File(whiteListFolder, list.replaceAll("\\W+", "") + ".txt");
            if (subs.exists() && !force) continue;
            try {
                Tools.DownloadFile(list, subs.getPath());
                if (!subs.exists()) continue;
                RaiderManager.parseTwitchSubsWhiteList(subs);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void parseTwitchSubsWhiteList(File file) throws IOException {
        FileReader input = new FileReader(file);
        BufferedReader bufRead = new BufferedReader(input);
        String myLine = null;
        try {
            while ((myLine = bufRead.readLine()) != null) {
                String[] array2 = myLine.split("\n");
                for (int i = 0; i < array2.length; ++i) {
                    RaiderManager.addNewRaider(array2[i], 10);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addYouTubers() {
    }

    static {
        raidersList.put("Gen_Deathrow", new RaiderData(new GameProfile(null, "Gen_Deathrow"), 10));
        raidersList.put("Funwayguy", new RaiderData(new GameProfile(null, "Funwayguy"), 10));
        raidersList.put("Darkosto", new RaiderData(new GameProfile(null, "Darkosto"), 10));
        raidersList.put("Kashdeya", new RaiderData(new GameProfile(null, "Kashdeya"), 10));
        raidersList.put("TheMattaBase", new RaiderData(new GameProfile(null, "TheMattaBase"), 10));
        raidersList.put("Jsl7", new RaiderData(new GameProfile(null, "Jsl7"), 10));
        raidersList.put("Turkey2349", new RaiderData(new GameProfile(null, "Turkey2349"), 10));
        raidersList.put("Bacon_Donut", new RaiderData(new GameProfile(null, "Bacon_Donut"), 10));
        raidersList.put("SlothMonster_", new RaiderData(new GameProfile(null, "SlothMonster_"), 10));
        raidersList.put("GWSheridan", new RaiderData(new GameProfile(null, "GWSheridan"), 10));
        raidersList.put("DatFailGamur", new RaiderData(new GameProfile(null, "DatFailGamur"), 10));
        raidersList.put("darkphan", new RaiderData(new GameProfile(null, "darkphan"), 10));
        raidersList.put("SinfulDeity", new RaiderData(new GameProfile(null, "SinfulDeity"), 10));
        raidersList.put("Gooderness", new RaiderData(new GameProfile(null, "Gooderness"), 10));
        raidersList.put("Vash505", new RaiderData(new GameProfile(null, "Vash505"), 10));
        raidersList.put("LexManos", new RaiderData(new GameProfile(null, "LexManos"), 10));
        raidersList.put("cpw11", new RaiderData(new GameProfile(null, "cpw11"), 10));
        raidersList.put("ganymedes01", new RaiderData(new GameProfile(null, "ganymedes01"), 10));
        raidersList.put("iChun", new RaiderData(new GameProfile(null, "iChun"), 10));
        raidersList.put("direwolf20", new RaiderData(new GameProfile(null, "direwolf20"), 10));
        raidersList.put("tfox83", new RaiderData(new GameProfile(null, "tfox83"), 10));
        raidersList.put("slowpoke101", new RaiderData(new GameProfile(null, "slowpoke101"), 10));
        raidersList.put("Notch", new RaiderData(new GameProfile(null, "Notch"), 10));
        raidersList.put("jeb_", new RaiderData(new GameProfile(null, "jeb_"), 10));
        raidersList.put("EvilSeph", new RaiderData(new GameProfile(null, "EvilSeph"), 10));
        raidersList.put("C418", new RaiderData(new GameProfile(null, "C418"), 10));
        raidersList.put("carnalizer", new RaiderData(new GameProfile(null, "carnalizer"), 10));
    }
}

