/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.handlers;

import com.gendeathrow.pmobs.core.ConfigHandler;
import com.gendeathrow.pmobs.core.RaidersCore;
import com.gendeathrow.pmobs.handlers.random.ArmorSetWeigthedItem;
import com.gendeathrow.pmobs.handlers.random.EquipmentWeigthedItem;
import com.gendeathrow.pmobs.util.JsonHelper;
import com.gendeathrow.pmobs.util.NBTConverter;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class EquipmentManager {
    public static ArrayList<ArmorSetWeigthedItem> armorList = new ArrayList();
    public static ArrayList<EquipmentWeigthedItem> mainHandList = new ArrayList();
    public static ArrayList<EquipmentWeigthedItem> offHandList = new ArrayList();
    public static ArrayList<EquipmentWeigthedItem> tippedArrows = new ArrayList();
    public static final File equipmentFile = new File(ConfigHandler.configDir, "equipment.json");
    public static final Random rand = new Random();
    private static boolean markDirty = false;
    public static ArrayList<String> ErrorList = new ArrayList();

    public static ArmorSetWeigthedItem getRandomArmor() {
        return (ArmorSetWeigthedItem)WeightedRandom.func_76271_a((Random)rand, armorList);
    }

    public static EquipmentWeigthedItem getRandomWeapons() {
        return (EquipmentWeigthedItem)WeightedRandom.func_76271_a((Random)rand, mainHandList);
    }

    public static EquipmentWeigthedItem getRandomOffHand() {
        return (EquipmentWeigthedItem)WeightedRandom.func_76271_a((Random)rand, offHandList);
    }

    public static EquipmentWeigthedItem getRandomArrows() {
        return (EquipmentWeigthedItem)WeightedRandom.func_76271_a((Random)rand, tippedArrows);
    }

    private static List<ArmorSetWeigthedItem> getWeightedList() {
        return Lists.newArrayList(armorList);
    }

    public static void Save() {
        if (markDirty) {
            markDirty = false;
        }
    }

    public static void readEquipmentFile() {
        EquipmentManager.GenerateDefault();
        if (equipmentFile.isFile()) {
            try {
                EquipmentManager.LoadEquipment(JsonHelper.ReadJsonFile(equipmentFile));
            }
            catch (JsonParseException jsonparseexception) {
                RaidersCore.logger.error("Couldn't parse Equipment file " + equipmentFile, (Throwable)jsonparseexception);
            }
        }
    }

    private static void LoadEquipment(JsonObject jsonObject) {
        ItemStack stack;
        JsonObject itemNBT;
        String itemID;
        EquipmentWeigthedItem weightedItem;
        JsonObject data;
        armorList.clear();
        offHandList.clear();
        mainHandList.clear();
        ErrorList.clear();
        if (jsonObject.has("Armor_Sets")) {
            for (JsonElement element : jsonObject.get("Armor_Sets").getAsJsonArray()) {
                data = element.getAsJsonObject();
                ArmorSetWeigthedItem weightedArmor = null;
                String head = null;
                JsonObject headNBT = null;
                String body = null;
                JsonObject bodyNBT = null;
                String legs = null;
                JsonObject legsNBT = null;
                String feet = null;
                Object feetNBT = null;
                boolean fullSet = false;
                int weight = 10;
                if (data.has("name")) {
                    String string = data.get("name").getAsString();
                }
                if (data.has("head")) {
                    head = data.get("head").getAsString();
                }
                if (data.has("body")) {
                    body = data.get("body").getAsString();
                }
                if (data.has("legs")) {
                    legs = data.get("legs").getAsString();
                }
                if (data.has("feet")) {
                    feet = data.get("feet").getAsString();
                }
                if (data.has("head_nbt") && data.get("head_nbt").isJsonObject()) {
                    headNBT = data.get("head_nbt").getAsJsonObject();
                }
                if (data.has("body_nbt") && data.get("body_nbt").isJsonObject()) {
                    bodyNBT = data.get("body_nbt").getAsJsonObject();
                }
                if (data.has("legs_nbt") && data.get("legs_nbt").isJsonObject()) {
                    legsNBT = data.get("legs_nbt").getAsJsonObject();
                }
                if (data.has("feet_nbt") && data.get("feet_nbt").isJsonObject()) {
                    feetNBT = data.get("feet_nbt").getAsJsonObject();
                }
                if (data.has("always spawn full set")) {
                    fullSet = data.get("always spawn full set").getAsBoolean();
                }
                if (data.has("weight")) {
                    weight = data.get("weight").getAsInt();
                }
                ItemStack headStack = null;
                ItemStack bodyStack = null;
                ItemStack legsStack = null;
                ItemStack feetStack = null;
                if (head != null) {
                    headStack = EquipmentManager.getItemStackFromID(head);
                    EquipmentManager.setNBTData(headNBT, headStack);
                }
                if (body != null) {
                    bodyStack = EquipmentManager.getItemStackFromID(body);
                    EquipmentManager.setNBTData(bodyNBT, bodyStack);
                }
                if (legs != null) {
                    legsStack = EquipmentManager.getItemStackFromID(legs);
                    EquipmentManager.setNBTData(legsNBT, legsStack);
                }
                if (feet != null) {
                    feetStack = EquipmentManager.getItemStackFromID(feet);
                    EquipmentManager.setNBTData((JsonObject)feetNBT, feetStack);
                }
                if ((weightedArmor = new ArmorSetWeigthedItem(headStack, bodyStack, legsStack, feetStack, weight, fullSet)) == null) continue;
                armorList.add(weightedArmor);
            }
        }
        if (jsonObject.has("MainHand/Weapon")) {
            for (JsonElement element : jsonObject.get("MainHand/Weapon").getAsJsonArray()) {
                data = element.getAsJsonObject();
                weightedItem = null;
                itemID = null;
                itemNBT = null;
                int weight = 10;
                if (data.has("itemID")) {
                    itemID = data.get("itemID").getAsString();
                }
                if (data.has("nbt") && data.get("nbt").isJsonObject()) {
                    itemNBT = data.get("nbt").getAsJsonObject();
                }
                if (data.has("weight")) {
                    weight = data.get("weight").getAsInt();
                }
                stack = EquipmentManager.getItemStackFromID(itemID);
                EquipmentManager.setNBTData(itemNBT, stack);
                if (stack != null) {
                    weightedItem = new EquipmentWeigthedItem(stack, weight);
                }
                if (weightedItem == null) continue;
                mainHandList.add(weightedItem);
            }
        }
        if (jsonObject.has("OffHand")) {
            for (JsonElement element : jsonObject.get("OffHand").getAsJsonArray()) {
                data = element.getAsJsonObject();
                weightedItem = null;
                itemID = null;
                itemNBT = null;
                int weight = 10;
                if (data.has("itemID")) {
                    itemID = data.get("itemID").getAsString();
                }
                if (data.has("nbt") && data.get("nbt").isJsonObject()) {
                    itemNBT = data.get("nbt").getAsJsonObject();
                }
                if (data.has("weight")) {
                    weight = data.get("weight").getAsInt();
                }
                stack = EquipmentManager.getItemStackFromID(itemID);
                EquipmentManager.setNBTData(itemNBT, stack);
                if (stack != null) {
                    weightedItem = new EquipmentWeigthedItem(stack, weight);
                }
                if (weightedItem == null) continue;
                offHandList.add(weightedItem);
            }
        }
        if (jsonObject.has("Tipped_Arrows_Effects")) {
            for (JsonElement arrowSet : jsonObject.get("Tipped_Arrows_Effects").getAsJsonArray()) {
                JsonObject potionID;
                ItemStack arrowTip = new ItemStack(Items.field_185167_i);
                weightedItem = null;
                itemID = null;
                itemNBT = null;
                int weight = 10;
                int ticks = 60;
                Object customName = null;
                JsonObject arrowElement = arrowSet.getAsJsonObject();
                if (arrowElement.has("nbt") && arrowElement.get("nbt").isJsonObject()) {
                    itemNBT = arrowElement.get("nbt").getAsJsonObject();
                }
                if (arrowElement.has("weight")) {
                    weight = arrowElement.get("weight").getAsInt();
                }
                if (arrowElement.has("ticks")) {
                    ticks = arrowElement.get("ticks").getAsInt();
                }
                arrowTip.func_151001_c(arrowSet + " " + arrowTip.func_82833_r());
                EquipmentManager.setNBTData(itemNBT, arrowTip);
                if (!arrowElement.has("TippedArrowsPotions")) continue;
                ArrayList<PotionEffect> collection = new ArrayList<PotionEffect>();
                if (arrowElement.get("TippedArrowsPotions").isJsonArray()) {
                    JsonArray TippedArrows = arrowElement.get("TippedArrowsPotions").getAsJsonArray();
                    for (JsonElement potionID2 : TippedArrows) {
                        if (!potionID2.getAsJsonObject().has("potionID")) continue;
                        Potion potion = Potion.func_180142_b((String)potionID2.getAsJsonObject().get("potionID").getAsString());
                        if (potion != null) {
                            collection.add(new PotionEffect(potion, ticks));
                            continue;
                        }
                        ErrorList.add(potionID2.getAsJsonObject().get("potionID").getAsString());
                        RaidersCore.logger.error("Potion could not be Found: " + potionID2.getAsJsonObject().get("potionID").getAsString());
                    }
                } else if (arrowElement.get("TippedArrowsPotions").isJsonObject() && (potionID = arrowElement.get("TippedArrowsPotions").getAsJsonObject()).has("potionID")) {
                    Potion potion = Potion.func_180142_b((String)potionID.get("potionID").getAsString());
                    if (potion != null) {
                        collection.add(new PotionEffect(potion, ticks));
                    } else {
                        ErrorList.add(potionID.get("potionID").getAsString());
                        RaidersCore.logger.error("Potion could not be Found: " + potionID.get("potionID").getAsString());
                    }
                }
                if (arrowTip != null && !collection.isEmpty()) {
                    PotionUtils.func_185184_a((ItemStack)arrowTip, collection);
                    weightedItem = new EquipmentWeigthedItem(arrowTip, weight);
                }
                if (weightedItem == null) continue;
                tippedArrows.add(weightedItem);
            }
        }
        RaidersCore.logger.info("MainHandList Size: " + mainHandList.size());
        RaidersCore.logger.info("OffHand Size: " + offHandList.size());
        RaidersCore.logger.info("Armor Sets Size: " + armorList.size());
        RaidersCore.logger.info("Tipped Arrows Size: " + tippedArrows.size());
        RaidersCore.logger.info("Errors: " + ErrorList.size());
    }

    private static ItemStack getItemStackFromID(String itemID) {
        String[] args = itemID.split(":");
        ItemStack stack = null;
        Item item = null;
        int meta = 0;
        if (args.length == 3) {
            try {
                meta = Integer.parseInt(args[2]);
                item = Item.func_111206_d((String)(args[0] + ":" + args[1]));
            }
            catch (Exception e) {
                item = Item.func_111206_d((String)(args[0] + ":" + args[1]));
            }
        } else {
            item = Item.func_111206_d((String)(args[0] + ":" + args[1]));
        }
        if (item != null) {
            stack = new ItemStack(Item.func_111206_d((String)(args[0] + ":" + args[1])), 1, meta);
        } else {
            ErrorList.add(itemID);
            RaidersCore.logger.error("Item could not be Found: " + itemID);
        }
        return stack;
    }

    private static ItemStack setNBTData(JsonObject nbt, ItemStack stack) {
        if (nbt != null && stack != null) {
            try {
                NBTTagCompound tags = new NBTTagCompound();
                NBTConverter.JSONtoNBT_Object(nbt, tags);
                if (!tags.func_82582_d()) {
                    stack.func_77982_d(tags);
                }
            }
            catch (Exception e) {
                RaidersCore.logger.error("Error Saving Stack to NBT " + stack.func_82833_r() + e);
                return stack;
            }
        }
        return stack;
    }

    public static void saveEquipmentFile() {
        FileOutputStream fo = null;
        try {
            fo = FileUtils.openOutputStream((File)equipmentFile);
            fo.close();
        }
        catch (IOException ioexception) {
            RaidersCore.logger.error("Couldn't save stats", (Throwable)ioexception);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fo);
        }
    }

    public static JsonObject dumpJson(ArrayList<EquipmentWeigthedItem> list) {
        JsonObject jsonobject = new JsonObject();
        for (EquipmentWeigthedItem entry : list) {
            if (entry == null) continue;
            JsonObject jsonObject = new JsonObject();
        }
        return jsonobject;
    }

    public static File GenerateDefault() {
        try {
            File file = equipmentFile;
            if (file.exists()) {
                return file;
            }
            file.createNewFile();
            if (file.canWrite()) {
                FileWriter fw = new FileWriter(file);
                JsonObject json = new JsonObject();
                JsonArray ArmorSet = new JsonArray();
                JsonArray armorSetsArray = new JsonArray();
                JsonArray OffHandSlots = new JsonArray();
                JsonArray arrowTipArray = new JsonArray();
                JsonArray MainHand = new JsonArray();
                JsonObject object = new JsonObject();
                object.addProperty("name", "Leather Armor Set");
                object.addProperty("head", "minecraft:leather_helmet");
                object.addProperty("body", "minecraft:leather_chestplate");
                object.addProperty("legs", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151026_S)).toString());
                object.addProperty("feet", "minecraft:leather_boots");
                object.add("head_nbt", (JsonElement)new JsonObject());
                object.add("body_nbt", (JsonElement)new JsonObject());
                object.add("legs_nbt", (JsonElement)new JsonObject());
                object.add("feet_nbt", (JsonElement)new JsonObject());
                object.addProperty("always spawn full set", Boolean.valueOf(false));
                object.addProperty("weight", (Number)20);
                ArmorSet.add((JsonElement)object);
                object = new JsonObject();
                JsonArray blank = new JsonArray();
                object.addProperty("name", "Iron Armor Set");
                object.addProperty("head", "minecraft:iron_helmet");
                object.addProperty("body", "minecraft:iron_chestplate");
                object.addProperty("legs", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151165_aa)).toString());
                object.addProperty("feet", "minecraft:iron_boots");
                object.add("head_nbt", (JsonElement)new JsonObject());
                object.add("body_nbt", (JsonElement)new JsonObject());
                object.add("legs_nbt", (JsonElement)new JsonObject());
                object.add("feet_nbt", (JsonElement)new JsonObject());
                object.addProperty("always spawn full set", Boolean.valueOf(false));
                object.addProperty("weight", (Number)20);
                ArmorSet.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("name", "Gold Armor Set");
                object.addProperty("head", "minecraft:golden_helmet");
                object.addProperty("body", "minecraft:golden_chestplate");
                object.addProperty("legs", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151149_ai)).toString());
                object.addProperty("feet", "minecraft:golden_boots");
                object.add("head_nbt", (JsonElement)new JsonObject());
                object.add("body_nbt", (JsonElement)new JsonObject());
                object.add("legs_nbt", (JsonElement)new JsonObject());
                object.add("feet_nbt", (JsonElement)new JsonObject());
                object.addProperty("always spawn full set", Boolean.valueOf(false));
                object.addProperty("weight", (Number)10);
                ArmorSet.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("name", "Diamond Armor Set");
                object.addProperty("head", "minecraft:diamond_helmet");
                object.addProperty("body", "minecraft:diamond_chestplate");
                object.addProperty("legs", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151173_ae)).toString());
                object.addProperty("feet", "minecraft:diamond_boots");
                object.add("head_nbt", (JsonElement)new JsonObject());
                object.add("body_nbt", (JsonElement)new JsonObject());
                object.add("legs_nbt", (JsonElement)new JsonObject());
                object.add("feet_nbt", (JsonElement)new JsonObject());
                object.addProperty("always spawn full set", Boolean.valueOf(false));
                object.addProperty("weight", (Number)10);
                ArmorSet.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("name", "Chain Mail Armor Set");
                object.addProperty("head", "minecraft:chainmail_helmet");
                object.addProperty("body", "minecraft:chainmail_chestplate");
                object.addProperty("legs", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151022_W)).toString());
                object.addProperty("feet", "minecraft:chainmail_boots");
                object.add("head_nbt", (JsonElement)new JsonObject());
                object.add("body_nbt", (JsonElement)new JsonObject());
                object.add("legs_nbt", (JsonElement)new JsonObject());
                object.add("feet_nbt", (JsonElement)new JsonObject());
                object.addProperty("always spawn full set", Boolean.valueOf(false));
                object.addProperty("weight", (Number)10);
                ArmorSet.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:wooden_sword");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)20);
                MainHand.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:iron_sword");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)20);
                MainHand.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:golden_sword");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                MainHand.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:diamond_sword");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                MainHand.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:feather");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)20);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:map");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)20);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:stick");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                object.addProperty("itemID", "minecraft:skull:1");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                JsonObject head = new JsonObject();
                head.addProperty("SkullOwner", "Gen_Deathrow");
                object.addProperty("itemID", "minecraft:skull:3");
                object.add("nbt", (JsonElement)head);
                object.addProperty("weight", (Number)10);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                head = new JsonObject();
                head.addProperty("SkullOwner", "Darkosto");
                object.addProperty("itemID", "minecraft:skull:3");
                object.add("nbt", (JsonElement)head);
                object.addProperty("weight", (Number)10);
                OffHandSlots.add((JsonElement)object);
                object = new JsonObject();
                JsonArray potionsArray = new JsonArray();
                JsonObject potion = new JsonObject();
                potion.addProperty("potionID", "slowness");
                object.addProperty("CustomName", "Slowness");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)5);
                object.addProperty("ticks", (Number)60);
                object.add("TippedArrowsPotions", (JsonElement)potion);
                arrowTipArray.add((JsonElement)object);
                object = new JsonObject();
                potion = new JsonObject();
                potion.addProperty("potionID", "instant_damage");
                object.addProperty("CustomName", "Harmful");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                object.addProperty("ticks", (Number)20);
                object.add("TippedArrowsPotions", (JsonElement)potion);
                arrowTipArray.add((JsonElement)object);
                object = new JsonObject();
                potion = new JsonObject();
                potion.addProperty("potionID", "nausea");
                potionsArray.add((JsonElement)potion);
                object.addProperty("CustomName", "Harmful");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)5);
                object.addProperty("ticks", (Number)30);
                object.add("TippedArrowsPotions", (JsonElement)potion);
                arrowTipArray.add((JsonElement)object);
                object = new JsonObject();
                potionsArray = new JsonArray();
                potion = new JsonObject();
                potion.addProperty("potionID", "poison");
                JsonObject potion2 = new JsonObject();
                potion2.addProperty("potionID", "weakness");
                potionsArray.add((JsonElement)potion);
                potionsArray.add((JsonElement)potion2);
                object.addProperty("CustomName", "Poisonous");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)10);
                object.addProperty("ticks", (Number)30);
                object.add("TippedArrowsPotions", (JsonElement)potionsArray);
                arrowTipArray.add((JsonElement)object);
                object = new JsonObject();
                potion = new JsonObject();
                potion.addProperty("potionID", "weakness");
                object.addProperty("CustomName", "Weakness");
                object.add("nbt", (JsonElement)new JsonObject());
                object.addProperty("weight", (Number)25);
                object.addProperty("ticks", (Number)30);
                object.add("TippedArrowsPotions", (JsonElement)potion);
                arrowTipArray.add((JsonElement)object);
                json.add("Armor_Sets", (JsonElement)ArmorSet);
                json.add("MainHand/Weapon", (JsonElement)MainHand);
                json.add("OffHand", (JsonElement)OffHandSlots);
                json.add("Tipped_Arrows_Effects", (JsonElement)arrowTipArray);
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)fw);
                fw.flush();
                fw.close();
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

