/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.handlers;

import com.gendeathrow.pmobs.core.PMSettings;
import com.gendeathrow.pmobs.entity.New.EntityRaiderBase;
import java.util.Random;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class DifficultyProgression {
    protected EntityRaiderBase raider;
    private Random rand;

    public DifficultyProgression(EntityRaiderBase raiderIn) {
        this.raider = raiderIn;
        this.rand = raiderIn.func_70681_au();
    }

    public double calculateProgressionDifficulty(double eachIncrease) {
        return eachIncrease * (double)this.getRaidDifficulty();
    }

    public double calculateProgressionDifficulty(double eachIncrease, double Max) {
        return this.calculateProgressionDifficulty(eachIncrease, 0, Max);
    }

    public double calculateProgressionDifficulty(double eachIncrease, int startDifficulty, double Max) {
        if (this.getRaidDifficulty() > startDifficulty) {
            return eachIncrease * (double)this.getRaidDifficulty() > Max ? Max : eachIncrease * (double)this.getRaidDifficulty();
        }
        return 0.0;
    }

    public int getDay() {
        return (int)(this.raider.field_70170_p.func_72820_D() / 24000L);
    }

    public static int getDay(World worldObj) {
        return (int)(worldObj.func_72820_D() / 24000L);
    }

    public int getRaidDifficulty() {
        return this.getDay() / PMSettings.dayDifficultyProgression;
    }

    public static int getRaidDifficulty(World worldObj) {
        return DifficultyProgression.getDay(worldObj) / PMSettings.dayDifficultyProgression;
    }

    public void setSpeedDifficulty(DifficultyInstance difficulty) {
        if (this.raider.func_70631_g_() || this.raider.isHeroBrine() || this.raider.getRaiderRole() != EntityRaiderBase.EnumRaiderRole.NONE || this.raider.getRaiderRole() != EntityRaiderBase.EnumRaiderRole.PYROMANIAC) {
            return;
        }
        if (this.rand.nextDouble() < this.calculateProgressionDifficulty(PMSettings.SpeedPercentageIncrease, PMSettings.SpeedMaxPercentage)) {
            double speedbase = 0.25;
            if (this.raider.getRaiderRole() == EntityRaiderBase.EnumRaiderRole.BRUTE) {
                speedbase = 0.15;
            }
            double speed = speedbase * this.rand.nextDouble();
            this.raider.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(EntityRaiderBase.SPEED_BOOST_ID, "Speed Bonus", speed, 0));
        }
    }

    public void setHealthDifficulty(DifficultyInstance difficulty) {
        double extraHealth;
        boolean addDefaultHealth;
        double healthChance = this.calculateProgressionDifficulty(PMSettings.BonusHealthPercentageIncrease, PMSettings.BonusHealthMaxPercentage) + (double)(difficulty.func_180170_c() * 0.015f);
        boolean bl = addDefaultHealth = this.getRaidDifficulty() >= 1;
        double d = PMSettings.HealthMaxOut < 0 ? this.calculateProgressionDifficulty(PMSettings.HealthIncrease) : (extraHealth = this.getRaidDifficulty() >= PMSettings.HealthMaxOut ? (double)(PMSettings.HealthIncrease * PMSettings.HealthMaxOut) : this.calculateProgressionDifficulty(PMSettings.HealthIncrease));
        if ((double)this.rand.nextFloat() < healthChance) {
            this.raider.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Health bonus", this.rand.nextDouble() * 4.0 + 1.0 + extraHealth, 0));
        } else if (addDefaultHealth || this.raider.getRaiderRole() == EntityRaiderBase.EnumRaiderRole.WITCH) {
            this.raider.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Small Health bonus", this.rand.nextDouble() + 1.0 + extraHealth, 0));
        }
        if (this.raider.func_70631_g_()) {
            this.raider.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Child Health", -0.75, 2));
        }
    }

    public void setDamageDifficulty(DifficultyInstance difficulty) {
        if (this.raider.func_70631_g_()) {
            this.raider.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Child Dmg", -0.5, 2));
        } else if (this.raider.getRaiderRole() == EntityRaiderBase.EnumRaiderRole.TWEAKER) {
            this.raider.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Tweaker Dmg", 1.0, 0));
        }
    }
}

