/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.entity.New;

import com.gendeathrow.pmobs.entity.New.EntityRaiderBase;
import com.gendeathrow.pmobs.entity.New.EntityRangedAttacker;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityHeroBrine
extends EntityRaiderBase {
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityRaiderBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastCreepySound;
    private int targetChangeTime;
    List<DamageSource> field_83001_bt = new ArrayList<DamageSource>();

    public EntityHeroBrine(World worldIn) {
        super(worldIn);
        this.field_83001_bt.add(DamageSource.field_76369_e);
        this.field_83001_bt.add(DamageSource.field_76367_g);
        this.field_83001_bt.add(DamageSource.field_76372_a);
        this.field_83001_bt.add(DamageSource.field_76371_c);
        this.field_83001_bt.add(DamageSource.field_76379_h);
        this.field_83001_bt.add(DamageSource.field_180137_b);
        this.field_83001_bt.add(DamageSource.field_76370_b);
        this.field_83001_bt.add(DamageSource.field_76372_a);
        this.field_83001_bt.add(DamageSource.field_82727_n);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    @Override
    public boolean isHeroBrine() {
        return this.getOwner().toLowerCase().equals("herobrine");
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K && this.isHeroBrine()) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    protected void func_184594_b(BlockPos pos) {
        if (this.isHeroBrine()) {
            EnchantmentFrostWalker.func_185266_a((EntityLivingBase)this, (World)this.field_70170_p, (BlockPos)pos, (int)2);
            EntityHeroBrine.coolLavaNearby((EntityLivingBase)this, this.field_70170_p, pos, 2);
        } else {
            super.func_184594_b(pos);
        }
    }

    public static void coolLavaNearby(EntityLivingBase living, World worldIn, BlockPos pos, int level) {
        if (living.field_70122_E) {
            float f = Math.min(16, 2 + level);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.func_177963_a((double)f, -1.0, (double)f))) {
                IBlockState iblockstate1;
                if (!(blockpos$mutableblockpos1.func_177957_d(living.field_70165_t, living.field_70163_u, living.field_70161_v) <= (double)(f * f))) continue;
                blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos1.func_177958_n(), blockpos$mutableblockpos1.func_177956_o() + 1, blockpos$mutableblockpos1.func_177952_p());
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (iblockstate.func_185904_a() != Material.field_151579_a || (iblockstate1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1)).func_185904_a() != Material.field_151587_i || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !worldIn.func_175716_a(Blocks.field_150343_Z, (BlockPos)blockpos$mutableblockpos1, false, EnumFacing.DOWN, (Entity)null, (ItemStack)null)) continue;
                worldIn.func_175656_a((BlockPos)blockpos$mutableblockpos1, Blocks.field_150343_Z.func_176223_P());
                worldIn.func_175684_a(blockpos$mutableblockpos1.func_185334_h(), Blocks.field_150343_Z, MathHelper.func_76136_a((Random)living.func_70681_au(), (int)60, (int)120));
            }
        }
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.field_70460_b[3];
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    @Override
    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.isHeroBrine() && this.field_70146_Z.nextDouble() <= 0.75) {
            this.func_145779_a(Items.field_151079_bi, 1);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.isHeroBrine()) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        } else if (!this.field_70170_p.field_72995_K && this.isHeroBrine() && this.func_70651_bq().size() > 0) {
            this.func_70674_bp();
        }
        super.func_70636_d();
    }

    protected void func_70609_aI() {
        if (this.isHeroBrine()) {
            ++this.field_70725_aQ;
            this.func_82142_c(true);
            if (this.field_70725_aQ == 40) {
                if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                    int j;
                    int i = this.func_70693_a(this.field_70717_bb);
                    for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                    }
                }
                for (int k = 0; k < 20; ++k) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.DRAGON_BREATH, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                }
                this.func_70106_y();
            }
        } else {
            super.func_70609_aI();
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.isHeroBrine()) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindPlayer(this));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(BABY_SPEED_BOOST_ID);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(SPEED_BOOST_ID);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(60.0);
            if (((EntityRangedAttacker)this).isRangedAttacker) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                this.field_70714_bg.func_85156_a((EntityAIBase)((EntityRangedAttacker)this).aiArrowAttack);
                ((EntityRangedAttacker)this).isRangedAttacker = false;
            }
        }
        return livingdata;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportToEntityBack(Entity p_70816_1_) {
        EnumFacing facingEnum = p_70816_1_.func_174811_aO();
        Vec3i facing = facingEnum.func_176730_m();
        double dx = p_70816_1_.field_70165_t - (double)(facing.func_177958_n() * 2);
        double dy = p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e();
        double dz = p_70816_1_.field_70161_v - (double)(facing.func_177956_o() * 2);
        return this.teleportTo(dx, dy, dz);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : super.func_184639_G();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isHeroBrine()) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source instanceof EntityDamageSourceIndirect) {
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleportRandomly()) continue;
                    return true;
                }
                return false;
            }
            boolean flag = super.func_70097_a(source, amount);
            if (source.func_76346_g() != null && this.field_70146_Z.nextInt(10) <= 2 && source.func_76346_g() instanceof EntityPlayer) {
                this.teleportToEntityBack(source.func_76346_g());
            } else if (source.func_76363_c() && this.field_70146_Z.nextInt(10) <= 5) {
                this.teleportRandomly();
            }
            return flag;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (this.isHeroBrine() && this.field_83001_bt.contains(source)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityHeroBrine raider;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        public AIFindPlayer(EntityHeroBrine p_i45842_1_) {
            super((EntityCreature)p_i45842_1_, EntityPlayer.class, false);
            this.raider = p_i45842_1_;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.player = this.raider.field_70170_p.func_184150_a(this.raider.field_70165_t, this.raider.field_70163_u, this.raider.field_70161_v, d0, d0, (Function)null, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                    return p_apply_1_ != null && AIFindPlayer.this.raider.shouldAttackPlayer(p_apply_1_);
                }
            });
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.raider.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.raider.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.raider.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.raider) < 25.0 && this.teleportTime >= 40) {
                            if (this.raider.field_70146_Z.nextDouble() < 40.0) {
                                for (int i = 0; i < 64 && !this.raider.teleportToEntityBack((Entity)((EntityPlayer)this.field_75309_a)); ++i) {
                                }
                            } else {
                                this.raider.teleportRandomly();
                            }
                            this.teleportTime = 0;
                        }
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.raider) > 128.0 && this.teleportTime >= 30 && this.raider.teleportToEntity((Entity)this.field_75309_a)) {
                        if (this.raider.field_70146_Z.nextDouble() < 40.0) {
                            this.raider.teleportToEntityBack((Entity)((EntityPlayer)this.field_75309_a));
                        } else {
                            this.raider.teleportToEntity((Entity)((EntityPlayer)this.field_75309_a));
                        }
                        this.teleportTime = 0;
                    }
                    ++this.teleportTime;
                }
                super.func_75246_d();
            }
        }
    }
}

