/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EntityDropPod
extends Entity {
    public int fallTime;
    private boolean hurtEntities;
    private int fallHurtMax = 200;
    private float fallHurtAmount = 8.0f;
    int despawnOnGround = 300;
    boolean soundDrop = false;
    public static ArrayList<CalledDrop> dropPodqueue = new ArrayList();
    public int nextCall = 10;
    private int nextPod = 0;
    private int podMax = 4;
    private boolean spawned = false;
    private boolean spawning = false;

    public EntityDropPod(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.8f, 3.3f);
    }

    protected void func_70088_a() {
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L || !this.field_70160_al;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70143_R > 10.0f) {
            this.soundDrop = true;
        }
        if (this.field_70122_E) {
            --this.despawnOnGround;
            if (this.despawnOnGround <= 0) {
                this.func_70106_y();
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity passenger : this.func_184188_bt()) {
                    passenger.func_184210_p();
                }
            }
            if (this.soundDrop) {
                this.func_184185_a(SoundEvents.field_187539_bB, 5.0f, 1.0f);
                this.soundDrop = false;
            }
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (!this.field_70170_p.field_72995_K) {
            this.destroyBlocksInAABB(this.func_70046_E().func_72314_b(2.0, 2.0, 2.0));
            BlockPos blockpos1 = new BlockPos((Entity)this);
            if (this.field_70122_E) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
                this.field_70181_x *= -0.5;
            } else {
                this.HitEntitiesFalling(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.25, 0.25, 0.25)));
            }
        }
        super.func_70071_h_();
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || iblockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) {
                        if (block.func_176200_f((IBlockAccess)this.field_70170_p, blockpos) || block.isLeaves(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || block instanceof BlockLeaves || iblockstate.func_185904_a() == Material.field_151582_l) {
                            if (BlockFalling.func_185759_i((IBlockState)iblockstate)) continue;
                            flag = this.field_70170_p.func_175698_g(blockpos);
                            continue;
                        }
                        flag = true;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public boolean func_184228_n(Entity entityIn) {
        return true;
    }

    protected double getMaximumSpeed() {
        return 0.4;
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityMountEvent((Entity)player, (Entity)this, this.field_70170_p, true))) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (this.func_184207_aI()) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            DamageSource damagesource = DamageSource.field_82728_o;
            for (Entity entity : list) {
                this.damageHitEntity(entity, i);
            }
        }
    }

    private void damageHitEntity(Entity entity, float distance) {
        DamageSource damagesource = DamageSource.field_82728_o;
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (entity instanceof EntityDropPod) {
            entity.func_70106_y();
        } else if (!this.func_184215_y(entity)) {
            entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount)), this.fallHurtMax));
        }
    }

    private void HitEntitiesFalling(List<Entity> p_70970_1_) {
        double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 2.0, 0.0, d3 / d4 * 2.0);
            this.damageHitEntity(entity, this.field_70143_R);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74757_a("HurtEntities", this.hurtEntities);
        compound.func_74776_a("FallHurtAmount", this.fallHurtAmount);
        compound.func_74768_a("FallHurtMax", this.fallHurtMax);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.WORLD && dropPodqueue.size() > 0) {
            CalledDrop call = dropPodqueue.get(0);
            if (call == null || call.raider == null || call.dropPod == null || call.raider.field_70170_p == null) {
                return;
            }
            if (event.world == call.raider.field_70170_p && this.nextCall-- < 0) {
                event.world.func_72838_d((Entity)call.dropPod);
                event.world.func_72838_d((Entity)call.raider);
                call.raider.func_184220_m((Entity)call.dropPod);
                call.dropPod.func_184185_a(com.gendeathrow.pmobs.common.SoundEvents.SONIC_BOOM, 25.0f, 1.0f);
                this.nextCall = event.world.field_73012_v.nextInt(10) + 5;
                this.spawned = true;
                dropPodqueue.remove(0);
                this.spawned = false;
            }
        }
    }

    public static void addDropPodtoQueue(EntityLivingBase rider, EntityDropPod dropPod) {
        CalledDrop drop = new CalledDrop(rider, dropPod);
        dropPodqueue.add(drop);
    }

    public static class CalledDrop {
        EntityLivingBase raider;
        EntityDropPod dropPod;

        public CalledDrop(EntityLivingBase raider, EntityDropPod dropPod) {
            this.raider = raider;
            this.dropPod = dropPod;
        }
    }
}

