/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.core;

import com.gendeathrow.pmobs.client.RaidersSkinManager;
import com.gendeathrow.pmobs.commands.common.CommonCommands;
import com.gendeathrow.pmobs.common.SoundEvents;
import com.gendeathrow.pmobs.common.capability.player.IPlayerData;
import com.gendeathrow.pmobs.common.capability.player.PlayersData;
import com.gendeathrow.pmobs.common.capability.player.PlayersDataStorage;
import com.gendeathrow.pmobs.core.ConfigHandler;
import com.gendeathrow.pmobs.core.PMSettings;
import com.gendeathrow.pmobs.core.init.ModItems;
import com.gendeathrow.pmobs.core.init.ModRecipes;
import com.gendeathrow.pmobs.core.network.ClientUpdatePacket;
import com.gendeathrow.pmobs.core.network.RaiderDeathCntPacket;
import com.gendeathrow.pmobs.core.proxies.CommonProxy;
import com.gendeathrow.pmobs.entity.EntityDropPod;
import com.gendeathrow.pmobs.entity.EntityPlayerRaider;
import com.gendeathrow.pmobs.entity.EntitySignalTransmitter;
import com.gendeathrow.pmobs.util.ObfHelper;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="playerraiders", name="Player Raiders", version="1.3.20", dependencies="after:BiomesOPlenty", acceptedMinecraftVersions="[1.10.2]", guiFactory="com.gendeathrow.pmobs.client.ConfigGuiFactory")
public class RaidersCore {
    public static final String MODID = "playerraiders";
    public static final String NAME = "Player Raiders";
    public static final String VERSION = "1.3.20";
    public static final String CHANNELNAME = "genraiders";
    @Mod.Instance(value="playerraiders")
    public static RaidersCore instance;
    public static final String PROXY = "com.gendeathrow.pmobs.core.proxies";
    public static Logger logger;
    @SidedProxy(clientSide="com.gendeathrow.pmobs.core.proxies.ClientProxy", serverSide="com.gendeathrow.pmobs.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static CreativeTabs RaidersTab;
    public static ResourceLocation playerraidersloot;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ObfHelper.detectObfuscation();
        CapabilityManager.INSTANCE.register(IPlayerData.class, (Capability.IStorage)new PlayersDataStorage(), PlayersData.class);
        EntityRegistry.registerModEntity(EntityPlayerRaider.class, (String)"Raiders", (int)1, (Object)this, (int)80, (int)3, (boolean)true, (int)-3971048, (int)-6191748);
        EntityRegistry.registerModEntity(EntityDropPod.class, (String)"DropPod", (int)2, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntitySignalTransmitter.class, (String)"Transmitter", (int)3, (Object)this, (int)80, (int)1, (boolean)false);
        ConfigHandler.preInit();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNELNAME);
        network.registerMessage(RaiderDeathCntPacket.ClientHandler.class, RaiderDeathCntPacket.class, 0, Side.CLIENT);
        network.registerMessage(ClientUpdatePacket.ClientHandler.class, ClientUpdatePacket.class, 1, Side.CLIENT);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.Init(event);
        proxy.registerHandlers();
        ConfigHandler.load();
        SoundEvents.register();
        LootTableList.func_186375_a((ResourceLocation)playerraidersloot);
        Object[] biomes = new Biome[]{};
        for (Biome biomeEntry : ForgeRegistries.BIOMES.getValues()) {
            boolean flag = true;
            if (BiomeDictionary.isBiomeOfType((Biome)biomeEntry, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !PMSettings.spawnNether || BiomeDictionary.isBiomeOfType((Biome)biomeEntry, (BiomeDictionary.Type)BiomeDictionary.Type.END) && !PMSettings.spawnEnd || BiomeDictionary.isBiomeOfType((Biome)biomeEntry, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                flag = false;
            }
            if (!flag) continue;
            biomes = (Biome[])ArrayUtils.add((Object[])biomes, (Object)biomeEntry);
        }
        logger.info("Added " + biomes.length + " biomes to Raiders spawn list.");
        EntityRegistry.addSpawn(EntityPlayerRaider.class, (int)PMSettings.raidersSpawnWeight, (int)1, (int)PMSettings.raidersMaxGroupSpawn, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        ConfigHandler.PostLoad();
        ModRecipes.RegisterRecipes();
        DungeonHooks.addDungeonMob((String)"playerraiders.Raiders", (int)PMSettings.raidersSpawnerWeight);
        if (PMSettings.removeVanillaSpawners) {
            logger.info("Removeing Vanilla Spawners from Dungeon Hooks");
            if (DungeonHooks.removeDungeonMob((String)"Spider") == 0) {
                logger.error("Tried to remove Spider from Mob Spawner. It didn't exist.");
            }
            if (DungeonHooks.removeDungeonMob((String)"Skeleton") == 0) {
                logger.error("Tried to remove Skeleton from Mob Spawner. It didn't exist.");
            }
            if (DungeonHooks.removeDungeonMob((String)"Creeper") == 0) {
                logger.error("Tried to remove Creeper from Mob Spawner. It didn't exist.");
            }
            if (DungeonHooks.removeDungeonMob((String)"Zombie") == 0) {
                logger.error("Tried to remove Zombie from Mob Spawner. It didn't exist.");
            }
            if (DungeonHooks.removeDungeonMob((String)"Enderman") == 0) {
                logger.error("Treid to remove Enderman from Mob Spawner. It didn't exist.");
            }
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (proxy.isIntergratedServerRunning() || proxy.isClient()) {
            RaidersSkinManager.profileCache = event.getServer().func_152358_ax();
            RaidersSkinManager.sessionService = event.getServer().func_147130_as();
        }
        ICommandManager command = event.getServer().func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new CommonCommands());
    }

    static {
        RaidersTab = new CreativeTabs("Raiders"){

            public Item func_78016_d() {
                return ModItems.backupTransmitter;
            }
        };
        playerraidersloot = new ResourceLocation(MODID, "entities/playerraiders");
    }
}

