/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.common.items;

import com.gendeathrow.pmobs.core.RaidersCore;
import com.gendeathrow.pmobs.entity.EntityPlayerRaider;
import com.gendeathrow.pmobs.entity.New.EntityRaiderBase;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpecialSpawnEgg
extends Item {
    public static final Map<String, RaiderEggInfo> RAIDERS_EGGS = Maps.newLinkedHashMap();

    public SpecialSpawnEgg() {
        this.func_77637_a(RaidersCore.RaidersTab);
    }

    public String func_77653_i(ItemStack stack) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String s1 = SpecialSpawnEgg.getEntityIdFromItem(stack);
        if (s1 != null) {
            s = s + " " + I18n.func_74838_a((String)("entity.playerraiders.role." + s1.toLowerCase()));
        }
        return s;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = SpecialSpawnEgg.spawnCreature(worldIn, SpecialSpawnEgg.getEntityIdFromItem(stack), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            SpecialSpawnEgg.applyItemEntityDataToEntity(worldIn, playerIn, stack, entity);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("RaiderTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("RaiderTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemStackIn)) {
                Entity entity = SpecialSpawnEgg.spawnCreature(worldIn, SpecialSpawnEgg.getEntityIdFromItem(itemStackIn), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
                }
                if (entity instanceof EntityLivingBase && itemStackIn.func_82837_s()) {
                    entity.func_96094_a(itemStackIn.func_82833_r());
                }
                SpecialSpawnEgg.applyItemEntityDataToEntity(worldIn, playerIn, itemStackIn, entity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --itemStackIn.field_77994_a;
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Nullable
    public static Entity spawnCreature(World worldIn, @Nullable String entityID, double x, double y, double z) {
        if (entityID != null && RAIDERS_EGGS.containsKey(entityID)) {
            EntityPlayerRaider entity = null;
            RaiderEggInfo egginfo = RAIDERS_EGGS.get(entityID);
            for (int i = 0; i < 1; ++i) {
                entity = new EntityPlayerRaider(worldIn);
                if (!(entity instanceof EntityPlayerRaider)) continue;
                EntityPlayerRaider entityliving = entity;
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityliving.field_70759_as = entityliving.field_70177_z;
                entityliving.field_70761_aq = entityliving.field_70177_z;
                entityliving.CreateRaider(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), null, egginfo.role, egginfo.faction);
                worldIn.func_72838_d((Entity)entity);
                entityliving.func_70642_aH();
            }
            return entity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (RaiderEggInfo egg : RAIDERS_EGGS.values()) {
            ItemStack raiderNoClass = new ItemStack(itemIn, 1);
            SpecialSpawnEgg.applyIDToItemStack(raiderNoClass, egg.spawnedID);
            subItems.add(raiderNoClass);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyIDToItemStack(ItemStack stack, String id) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", id);
        nbttagcompound.func_74782_a("RaiderTag", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
    }

    @Nullable
    public static String getEntityIdFromItem(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.func_150297_b("RaiderTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("RaiderTag");
        return !nbttagcompound1.func_150297_b("id", 8) ? null : nbttagcompound1.func_74779_i("id");
    }

    static {
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.NONE.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.NONE.toString(), -3971048, 15677239, EntityRaiderBase.EnumRaiderRole.NONE, EntityRaiderBase.EnumFaction.HOSTILE));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.BRUTE.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.BRUTE.toString(), -3971048, 0x140000, EntityRaiderBase.EnumRaiderRole.BRUTE, EntityRaiderBase.EnumFaction.HOSTILE));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.PYROMANIAC.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.PYROMANIAC.toString(), -3971048, 15921673, EntityRaiderBase.EnumRaiderRole.PYROMANIAC, EntityRaiderBase.EnumFaction.HOSTILE));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.TWEAKER.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.TWEAKER.toString(), -3971048, 10492835, EntityRaiderBase.EnumRaiderRole.TWEAKER, EntityRaiderBase.EnumFaction.HOSTILE));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.WITCH.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.WITCH.toString(), -3971048, 971165, EntityRaiderBase.EnumRaiderRole.WITCH, EntityRaiderBase.EnumFaction.HOSTILE));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumFaction.FRIENDLY.toString(), new RaiderEggInfo(EntityRaiderBase.EnumFaction.FRIENDLY.toString(), -3971048, 65301, EntityRaiderBase.EnumRaiderRole.NONE, EntityRaiderBase.EnumFaction.FRIENDLY));
        RAIDERS_EGGS.put(EntityRaiderBase.EnumRaiderRole.RANGED.toString(), new RaiderEggInfo(EntityRaiderBase.EnumRaiderRole.RANGED.toString(), -3971048, 13132821, EntityRaiderBase.EnumRaiderRole.RANGED, EntityRaiderBase.EnumFaction.HOSTILE));
    }

    public static class RaiderEggInfo {
        public final String spawnedID;
        public final int primaryColor;
        public final int secondaryColor;
        public final EntityRaiderBase.EnumRaiderRole role;
        public final EntityRaiderBase.EnumFaction faction;

        public RaiderEggInfo(String spawnedIDIn, int primColor, int secondColor, EntityRaiderBase.EnumRaiderRole roleIn, EntityRaiderBase.EnumFaction factionIn) {
            this.spawnedID = spawnedIDIn;
            this.primaryColor = primColor;
            this.secondaryColor = secondColor;
            this.role = roleIn;
            this.faction = factionIn;
        }
    }
}

