/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;

public abstract class Base_Command {
    public abstract String getCommand();

    public List<String> getCommandAliases() {
        return Collections.emptyList();
    }

    public String getUsageSuffix() {
        return "";
    }

    public boolean validArgs(String[] args) {
        return args.length == 1;
    }

    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return new ArrayList<String>();
    }

    public abstract void runCommand(MinecraftServer var1, CommandBase var2, ICommandSender var3, String[] var4);

    public final WrongUsageException getException(CommandBase command) {
        String message = command.func_71517_b() + " " + this.getCommand();
        if (this.getUsageSuffix().length() > 0) {
            message = message + " " + this.getUsageSuffix();
        }
        return new WrongUsageException(message, new Object[0]);
    }

    public static int parseInt(String input) throws NumberInvalidException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
        }
    }

    public static int parseInt(String input, int min) throws NumberInvalidException {
        return Base_Command.parseInt(input, min, Integer.MAX_VALUE);
    }

    public static int parseInt(String input, int min, int max) throws NumberInvalidException {
        int i = Base_Command.parseInt(input);
        if (i < min) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{i, min});
        }
        if (i > max) {
            throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{i, max});
        }
        return i;
    }
}

