/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.client.data;

import com.gendeathrow.pmobs.client.ClientEventHandler;
import com.gendeathrow.pmobs.core.RaidersCore;
import com.gendeathrow.pmobs.util.Tools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class KillCounter {
    private static File killcounterFile = new File("raidersKillCnt.txt");
    public static HashMap<String, Integer> killcnt = new HashMap();

    public static void initilize() {
        if (killcounterFile.exists()) {
            KillCounter.loadKillCounter();
        } else {
            KillCounter.SaveKillCounter();
        }
    }

    public static void loadKillCounter() {
        try {
            String[] split;
            String data = Tools.readFile(killcounterFile.getPath(), Charset.defaultCharset());
            for (String line : split = data.split("\n")) {
                String[] lineSplit = line.split(":");
                if (lineSplit.length <= 1) continue;
                try {
                    killcnt.put(lineSplit[0], Integer.parseInt(lineSplit[1]));
                }
                catch (NumberFormatException e) {
                    RaidersCore.logger.error("Issue parsing Number in " + killcounterFile.getPath());
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void SaveKillCounter() {
        String filedata = "";
        for (Map.Entry<String, Integer> killer : killcnt.entrySet()) {
            filedata = filedata + killer.getKey() + ":" + killer.getValue() + "\n";
        }
        System.out.print(filedata);
        try {
            PrintWriter out = new PrintWriter(killcounterFile);
            out.println(filedata);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static int addKillCount(String killer) {
        ClientEventHandler.whoKilled = killer;
        if (killcnt.containsKey(killer)) {
            killcnt.put(killer, killcnt.get(killer) + 1);
        } else {
            killcnt.put(killer, 1);
        }
        KillCounter.SaveKillCounter();
        return killcnt.get(killer);
    }

    public static String getKillCount(String killer) {
        if (killcnt.containsKey(killer)) {
            return "" + killcnt.get(killer);
        }
        return "0";
    }
}

