/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.client;

import com.gendeathrow.pmobs.core.RaidersCore;
import com.gendeathrow.pmobs.entity.New.EntityRaiderBase;
import com.gendeathrow.pmobs.handlers.RaiderData;
import com.gendeathrow.pmobs.handlers.RaiderManager;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class RaidersSkinManager {
    public static PlayerProfileCache profileCache;
    public static MinecraftSessionService sessionService;
    public final HashMap<String, ResourceLocation> cachedSkins = new HashMap();
    public static final RaidersSkinManager INSTANCE;
    private static Thread thread;
    private static Thread thread2;
    private static List<EntityRaiderBase> raiders;
    private static List<RaiderData> raidersdata;
    private static List<String> badraiders;

    public static void cacheSkins() {
        Iterator<RaiderData> raidersList = RaiderManager.getAllRaiders().values().iterator();
        while (raidersList.hasNext()) {
            RaidersSkinManager.updateProfile(raidersList.next());
        }
    }

    public static void updateProfile(RaiderData raiderInfo) {
        if (!badraiders.contains(raiderInfo.getOwnerName())) {
            raidersdata.add(raiderInfo);
        }
        if (thread2 == null || thread2.getState() == Thread.State.TERMINATED) {
            thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!raidersdata.isEmpty()) {
                        RaiderData raider = (RaiderData)((Object)raidersdata.get(0));
                        raider.setProfile(TileEntitySkull.func_174884_b((GameProfile)raider.getProfile()));
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        raidersdata.remove(0);
                    }
                }
            });
            thread2.start();
        }
    }

    public static void updateProfile(EntityRaiderBase raider) {
        if (!badraiders.contains(raider.getOwner())) {
            raiders.add(raider);
        }
        if (thread == null || thread.getState() == Thread.State.TERMINATED) {
            thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!raiders.isEmpty()) {
                        EntityRaiderBase raider = (EntityRaiderBase)((Object)raiders.get(0));
                        raider.setPlayerProfile(TileEntitySkull.func_174884_b((GameProfile)raider.getPlayerProfile()));
                        raider.setProfileUpdated(true);
                        try {
                            System.out.println("->" + raider.getOwner());
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        raiders.remove(0);
                    }
                }
            });
            thread.start();
        }
    }

    public static void cacheSkin(GameProfile profile) {
        profile = TileEntitySkull.func_174884_b((GameProfile)profile);
    }

    public static GameProfile setupProfiles(GameProfile input) {
        if (input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                return gameprofile;
            }
            return input;
        }
        return input;
    }

    public ResourceLocation cacheRaidersSkins(GameProfile gameprofile) {
        gameprofile = profileCache.func_152655_a(gameprofile.getName());
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (gameprofile != null) {
            Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(gameprofile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                resourcelocation = Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            } else {
                UUID uuid = EntityPlayer.func_146094_a((GameProfile)gameprofile);
                resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
            }
        }
        return resourcelocation;
    }

    public static void addToBadList(String owner) {
        if (!badraiders.contains(owner)) {
            badraiders.add(owner);
            RaidersCore.logger.error("Could not Get this players profile." + owner + " Added to the Naughty List");
        }
    }

    static {
        INSTANCE = new RaidersSkinManager();
        raiders = new ArrayList<EntityRaiderBase>();
        raidersdata = new ArrayList<RaiderData>();
        badraiders = new ArrayList<String>();
    }
}

