/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.pmobs.client;

import com.gendeathrow.pmobs.client.RaidersSkinManager;
import com.gendeathrow.pmobs.client.audio.CryingWitch;
import com.gendeathrow.pmobs.client.audio.DropPodMoving;
import com.gendeathrow.pmobs.client.data.KillCounter;
import com.gendeathrow.pmobs.client.gui.RaidNotification;
import com.gendeathrow.pmobs.common.SoundEvents;
import com.gendeathrow.pmobs.core.PMSettings;
import com.gendeathrow.pmobs.entity.EntityDropPod;
import com.gendeathrow.pmobs.entity.New.EntityRaiderBase;
import com.gendeathrow.pmobs.entity.New.EntityRangedAttacker;
import com.gendeathrow.pmobs.handlers.DifficultyProgression;
import com.gendeathrow.pmobs.handlers.EquipmentManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static String whoKilled = "";
    boolean hasCheckedSkins = false;
    boolean witchNear = false;
    int maxDistance = 35;

    @SubscribeEvent
    public void showDeathCount(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() == null) {
            return;
        }
        if (event.getGui() instanceof GuiGameOver && whoKilled != "") {
            String message = TextFormatting.YELLOW + whoKilled + " has killed you " + KillCounter.getKillCount(whoKilled) + " times!";
            event.getGui().func_73731_b(Minecraft.func_71410_x().field_71466_p, message, event.getGui().field_146294_l / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(message) / 2, 115, 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityRangedAttacker) {
            if (((EntityRangedAttacker)event.getEntity()).getRaiderRole() == EntityRaiderBase.EnumRaiderRole.WITCH) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new CryingWitch((EntityRangedAttacker)event.getEntity()));
            }
        } else if (event.getEntity() instanceof EntityDropPod) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DropPodMoving((EntityDropPod)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.hasCheckedSkins) {
            this.hasCheckedSkins = true;
            if (EquipmentManager.ErrorList.size() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentTranslation(EquipmentManager.ErrorList.size() + " Errors were found in Raiders Equipment json. Check Console for more info.", new Object[0]));
            }
            RaidersSkinManager.INSTANCE.cacheSkins();
        }
        if (event.player.field_70170_p == null || !event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.player.field_70170_p.func_72820_D() % 1000L != 0L || event.phase == TickEvent.Phase.END) {
            return;
        }
        int diff = DifficultyProgression.getRaidDifficulty(event.player.field_70170_p);
        if (PMSettings.lastRaidCheck != diff) {
            PMSettings.lastRaidCheck = diff;
            RaidNotification.ScheduleNotice("Raid Difficulty " + diff, "Raiders have gotten harder!", SoundEvents.RAID_DAY_SUSPENSE.getRegistryName().toString());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRender(EntityViewRenderEvent.RenderFogEvent event) {
        if (!PMSettings.screamerFogOn) {
            return;
        }
        this.witchNear = false;
        float fogDistance = 0.0f;
        if (event.getEntity() instanceof EntityPlayer && event.getEntity().field_70170_p != null) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            AxisAlignedBB box = player.func_174813_aQ();
            if (box == null) {
                return;
            }
            List list = player.field_70170_p.func_72872_a(EntityRaiderBase.class, box.func_72314_b((double)this.maxDistance, (double)this.maxDistance, (double)this.maxDistance));
            for (EntityRaiderBase entity : list) {
                if (entity.getRaiderRole() != EntityRaiderBase.EnumRaiderRole.WITCH || !((EntityRangedAttacker)entity).isWitchActive()) continue;
                this.witchNear = true;
                float percentage = (float)Math.pow(entity.func_70032_d((Entity)player) / (float)this.maxDistance, 5.0);
                fogDistance = percentage * event.getFarPlaneDistance();
            }
        }
        if (this.witchNear) {
            int fogStart = 8;
            int fogEnd = 20;
            GlStateManager.func_179095_a((float)0.1f);
            GlStateManager.func_179102_b((float)fogStart);
            GlStateManager.func_179153_c((float)Math.max(fogDistance, 20.0f));
        }
    }
}

