/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.types.AbstractTreeType;

public class Taiga1Tree
extends AbstractTreeType {
    public Taiga1Tree(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.leaftype = AbstractTreeType.LeafStyle.SPRUCE;
        this.topLimitDown = 1.5;
        this.topLimitUp = 0.0;
        this.genBuffer = 3;
        this.leafRad = 2.0;
    }

    @Override
    public int getBranchesPerNode(double nodeHeight, double scale) {
        return this.random.nextInt(2) + 3;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / (numBranches + 1.0);
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 1 + this.random.nextInt(2);
    }

    @Override
    public double getBranchPitch(double scale) {
        return -0.33;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double bottom = this.getLowestBranchRatio() * trunkHeight;
        double distFromBottom = nodeHeight - bottom;
        double branchSectionLength = trunkHeight - bottom;
        double taper = 1.0 - MathHelper.func_151237_a((double)(distFromBottom / branchSectionLength), (double)0.1, (double)0.9);
        return 1.0 + trunkHeight / 5.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(6 + this.random.nextInt(6)) + 6.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 4.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.35;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(2) + 2;
    }

    @Override
    public void doLeafNode(TreeInstance tree, Branch branch, BlockPos pos) {
        tree.setLeaf(pos.func_177984_a());
        tree.setLeaf(pos.func_177978_c());
        tree.setLeaf(pos.func_177974_f());
        tree.setLeaf(pos.func_177968_d());
        tree.setLeaf(pos.func_177976_e());
    }
}

