/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeGenMethods;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.types.AbstractTreeType;

public class SimpleTree
extends AbstractTreeType {
    public SimpleTree(World world, IBlockState wood, IBlockState branch, IBlockState leaf, boolean vines) {
        super(world, wood, branch, leaf);
        if (vines) {
            this.vines = this.random.nextInt(3) + 1;
        }
    }

    @Override
    public int getBranchesPerNode(double nodeHeight, double scale) {
        return this.random.nextInt(2) + 3;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 2.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double bottom = this.getLowestBranchRatio() * trunkHeight;
        double distFromBottom = nodeHeight - bottom;
        double branchSectionLength = trunkHeight - bottom;
        double taper = 1.0 - MathHelper.func_151237_a((double)(distFromBottom / branchSectionLength), (double)0.1, (double)0.9);
        return 1.0 + trunkHeight / 4.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(4 + this.random.nextInt(3) + 1) + 3.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return 2.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.8 + (double)this.random.nextFloat();
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return 4;
    }

    @Override
    public void doLeafNode(TreeInstance tree, Branch branch, BlockPos pos) {
        double height = (double)pos.func_177956_o() - tree.y;
        double taper = MathHelper.func_151237_a((double)(tree.type.leafTaper * (tree.trunkHeight - height) / tree.trunkHeight), (double)tree.type.leafTaper, (double)1.0);
        double radius = MathHelper.func_151237_a((double)(tree.type.leafRad * taper), (double)1.0, (double)tree.type.leafRad);
        double ymin = tree.type.leafYMin;
        double ymax = tree.type.leafYMax;
        for (double yloop = ymin; yloop < ymax; yloop += 1.0) {
            double sliceRadSq = (radius + 1.0) * (radius + 1.0) - yloop * yloop;
            double slicedRadSqSmall = radius * radius - yloop * yloop;
            if (!(sliceRadSq > 0.0)) continue;
            for (double xloop = -radius; xloop < radius + 1.0; xloop += 1.0) {
                for (double zloop = -radius; zloop < radius + 1.0; zloop += 1.0) {
                    double xzDistanceSq = xloop * xloop + zloop * zloop;
                    BlockPos leafPos = new BlockPos(xloop + (double)pos.func_177958_n(), yloop + (double)pos.func_177956_o(), zloop + (double)pos.func_177952_p());
                    if (xzDistanceSq < slicedRadSqSmall) {
                        tree.setLeaf(leafPos);
                        continue;
                    }
                    if (!(xzDistanceSq < sliceRadSq) || !tree.random.nextBoolean()) continue;
                    tree.setLeaf(leafPos);
                    if (tree.type.vines <= 0 || !(MathHelper.func_76132_a((double)xloop, (double)zloop) > yloop) || !tree.random.nextBoolean()) continue;
                    TreeGenMethods.genVine(tree, leafPos, xloop, zloop);
                }
            }
        }
    }
}

