/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import wtf.worldgen.GeneratorMethods;

public class Shrub {
    private final GeneratorMethods gen;
    private final IBlockState leaves;
    private final IBlockState wood;

    public Shrub(WorldGenShrub oldshrub, GeneratorMethods gen) {
        this.leaves = (IBlockState)ReflectionHelper.getPrivateValue(WorldGenShrub.class, (Object)oldshrub, (int)0);
        this.wood = (IBlockState)ReflectionHelper.getPrivateValue(WorldGenShrub.class, (Object)oldshrub, (int)1);
        this.gen = gen;
    }

    public boolean generate(World worldIn, Random rand, BlockPos position) {
        if (position == null) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(position);
        if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, position, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) {
            position = position.func_177984_a();
            this.gen.setTreeBlock(position, this.wood);
            for (int i = position.func_177956_o(); i <= position.func_177956_o() + 2; ++i) {
                int j = i - position.func_177956_o();
                int k = 2 - j;
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k; ++l) {
                    int i1 = l - position.func_177958_n();
                    for (int j1 = position.func_177952_p() - k; j1 <= position.func_177952_p() + k; ++j1) {
                        int k1 = j1 - position.func_177952_p();
                        if (Math.abs(i1) == k && Math.abs(k1) == k && rand.nextInt(2) == 0) continue;
                        BlockPos blockpos = new BlockPos(l, i, j1);
                        this.gen.setTreeBlock(blockpos, this.leaves);
                    }
                }
            }
        }
        return true;
    }
}

