/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.types.AbstractTreeType;

public class RedwoodTree
extends AbstractTreeType {
    public RedwoodTree(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.leaftype = AbstractTreeType.LeafStyle.SPRUCE;
        this.topLimitDown = 2.0;
        this.topLimitUp = 0.0;
        this.topLimitIncrement = 0.39269908169872414;
        this.genBuffer = -25;
        this.leafRad = 2.0;
    }

    @Override
    public int getBranchesPerNode(double taper, double scale) {
        double branches = 7.0 + 5.0 * scale;
        return (int)(branches + branches * taper);
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI * 2 / (numBranches + 1.0);
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 3 + this.random.nextInt(2);
    }

    @Override
    public double getBranchPitch(double scale) {
        return -0.35;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double bottom = this.getLowestBranchRatio() * trunkHeight;
        double distFromBottom = nodeHeight - bottom;
        double branchSectionLength = trunkHeight - bottom;
        double taper = 1.0 - MathHelper.func_151237_a((double)(distFromBottom / branchSectionLength), (double)0.1, (double)0.9);
        return trunkHeight / 4.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(33 + this.random.nextInt(33)) + 33.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 4.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return (double)(this.random.nextInt(4) + 4) + scale * 4.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        if (currentRadius > 1.0) {
            double thirdHeight = trunkHeight / 3.0;
            double rad = 1.0 - currentRadius / maxRadius;
            return (int)(thirdHeight + 2.0 * (thirdHeight * rad) + (double)this.random.nextInt(5) - 2.0);
        }
        return MathHelper.func_76143_f((double)trunkHeight);
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.6;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(4) + 4;
    }

    @Override
    public void doLeafNode(TreeInstance tree, Branch branch, BlockPos pos) {
        if ((double)pos.func_177956_o() < tree.trunkHeight + tree.y) {
            tree.setBranch(pos, branch.axis);
        }
        for (int loop = 0; loop < 5; ++loop) {
            double vecX = branch.vecX + (double)this.random.nextFloat() - 0.5;
            double vecY = branch.vecY + (double)this.random.nextFloat() - 0.25;
            double vecZ = branch.vecZ + (double)this.random.nextFloat() - 0.5;
            Branch twig = new Branch(tree, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), vecX, vecY, vecZ, 2.0);
            while (twig.hasNext()) {
                tree.setLeaf(twig.next());
            }
        }
    }
}

