/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeGenMethods;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.types.AbstractTreeType;

public class Mangrove
extends AbstractTreeType {
    public Mangrove(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.leafYMin = 0.0;
        this.leafYMax = 2.0;
        this.leafRad = 3.0;
        this.airGenerate = true;
        this.airGenHeight = 2.0;
        this.growDense = false;
        this.rootFinalAngle = 0.5;
        this.vines = 3;
        this.rootInitialAngle = 1.0;
        this.rootIncrementAngle = 99.0;
        this.setWaterGen(2);
        this.genBuffer = -10;
    }

    @Override
    public int getBranchesPerNode(double nodeHeight, double scale) {
        return (int)MathHelper.func_151237_a((double)this.random.nextInt(2), (double)1.0, (double)2.0);
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return this.random.nextInt(2) + 2;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        return trunkHeight / 2.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(7 + this.random.nextInt(7)) + 7.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 2.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return (double)(this.random.nextFloat() / 2.0f) + 0.25;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(2) + 3;
    }

    @Override
    public void doLeafNode(TreeInstance tree, Branch branch, BlockPos pos) {
        double height = (double)pos.func_177956_o() - tree.y;
        double taper = MathHelper.func_151237_a((double)(tree.type.leafTaper * (tree.trunkHeight - height) / tree.trunkHeight), (double)tree.type.leafTaper, (double)1.0);
        double radius = MathHelper.func_151237_a((double)(tree.type.leafRad * taper), (double)1.0, (double)tree.type.leafRad);
        double ymin = tree.type.leafYMin;
        double ymax = tree.type.leafYMax;
        for (double yloop = ymin; yloop < ymax; yloop += 1.0) {
            double sliceRadSq = (radius + 1.0) * (radius + 1.0) - yloop * yloop;
            double slicedRadSqSmall = radius * radius - yloop * yloop;
            if (!(sliceRadSq > 0.0)) continue;
            for (double xloop = -radius; xloop < radius + 1.0; xloop += 1.0) {
                for (double zloop = -radius; zloop < radius + 1.0; zloop += 1.0) {
                    double xzDistanceSq = xloop * xloop + zloop * zloop;
                    BlockPos leafPos = new BlockPos(xloop + (double)pos.func_177958_n(), yloop + (double)pos.func_177956_o(), zloop + (double)pos.func_177952_p());
                    if (xzDistanceSq < slicedRadSqSmall) {
                        tree.setLeaf(leafPos);
                        continue;
                    }
                    if (!(xzDistanceSq < sliceRadSq) || !tree.random.nextBoolean()) continue;
                    tree.setLeaf(leafPos);
                    if (tree.type.vines <= 0 || !(MathHelper.func_76132_a((double)xloop, (double)zloop) > yloop) || !tree.random.nextBoolean()) continue;
                    TreeGenMethods.genVine(tree, leafPos, xloop, zloop);
                }
            }
        }
    }
}

