/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeGenMethods;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.types.AbstractTreeType;

public class JungleGiant
extends AbstractTreeType {
    public JungleGiant(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.leafYMin = 0.0;
        this.leafYMax = 2.0;
        this.leafRad = 3.5;
        this.airGenerate = true;
        this.airGenHeight = 4.0;
        this.rootWall = true;
        this.growDense = true;
        this.cocoa = true;
        this.rootFinalAngle = 0.5;
        this.vines = 3;
        this.rootInitialAngle = 1.0;
        this.rootIncrementAngle = 0.3f;
        this.genBuffer = -6;
    }

    @Override
    public int getBranchesPerNode(double nodeHeight, double scale) {
        return 3;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI * 2 / (numBranches + 1.0);
    }

    @Override
    public double getBranchSeperation(double scale) {
        return this.random.nextInt(3) + 2;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.3 + (double)(this.random.nextFloat() / 5.0f);
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double bottom = this.getLowestBranchRatio() * trunkHeight;
        double distFromBottom = nodeHeight - bottom;
        double branchSectionLength = trunkHeight - bottom;
        double taper = 1.0 - MathHelper.func_151237_a((double)(distFromBottom / branchSectionLength), (double)0.1, (double)0.9);
        return trunkHeight / 3.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(37 + this.random.nextInt(16)) + 16.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 3.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 2.0 + 2.0 * scale;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        if (currentRadius > 1.0) {
            double thirdHeight = trunkHeight / 3.0;
            double rad = 1.0 - currentRadius / maxRadius;
            return (int)(thirdHeight + 2.0 * (thirdHeight * rad) + (double)this.random.nextInt(5) - 2.0);
        }
        return MathHelper.func_76143_f((double)trunkHeight);
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.25 + (double)(this.random.nextFloat() / 5.0f);
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return MathHelper.func_76128_c((double)(this.PId2 * (trunkDiameter + 1.0)));
    }

    @Override
    public void doLeafNode(TreeInstance tree, Branch branch, BlockPos pos) {
        double height = (double)pos.func_177956_o() - tree.y;
        double taper = MathHelper.func_151237_a((double)(tree.type.leafTaper * (tree.trunkHeight - height) / tree.trunkHeight), (double)tree.type.leafTaper, (double)1.0);
        double radius = MathHelper.func_151237_a((double)(tree.type.leafRad * taper), (double)1.0, (double)tree.type.leafRad);
        double ymin = tree.type.leafYMin;
        double ymax = tree.type.leafYMax;
        for (double yloop = ymin; yloop < ymax; yloop += 1.0) {
            double sliceRadSq = (radius + 1.0) * (radius + 1.0) - yloop * yloop;
            double slicedRadSqSmall = radius * radius - yloop * yloop;
            if (!(sliceRadSq > 0.0)) continue;
            for (double xloop = -radius; xloop < radius + 1.0; xloop += 1.0) {
                for (double zloop = -radius; zloop < radius + 1.0; zloop += 1.0) {
                    double xzDistanceSq = xloop * xloop + zloop * zloop;
                    BlockPos leafPos = new BlockPos(xloop + (double)pos.func_177958_n(), yloop + (double)pos.func_177956_o(), zloop + (double)pos.func_177952_p());
                    if (xzDistanceSq < slicedRadSqSmall) {
                        tree.setLeaf(leafPos);
                        continue;
                    }
                    if (!(xzDistanceSq < sliceRadSq) || !tree.random.nextBoolean()) continue;
                    tree.setLeaf(leafPos);
                    if (tree.type.vines <= 0 || !(MathHelper.func_76132_a((double)xloop, (double)zloop) > yloop) || !tree.random.nextBoolean()) continue;
                    TreeGenMethods.genVine(tree, leafPos, xloop, zloop);
                }
            }
        }
    }
}

