/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.utilities.simplex.SimplexHelper;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;

public abstract class AbstractTreeType {
    protected final Random random;
    protected double PId2 = 1.5707963267948966;
    public final IBlockState wood;
    public final IBlockState branch;
    public final IBlockState leaf;
    public static final SimplexHelper simplex = new SimplexHelper("TreeVars");
    public HashSet<Block> canGrowOn = new HashSet();
    public int waterGenerate = 0;
    public int vines = 0;
    public LeafStyle leaftype = LeafStyle.BASIC;
    public double leafRad = 2.5;
    public double leafYMin = -1.0;
    public double leafYMax = 2.0;
    public double leafTaper = 1.0;
    public boolean airGenerate = false;
    public double airGenHeight = 0.0;
    public double rootAirDivisor = 2.5;
    public double rootInitialAngle = 1.01;
    public double rootFinalAngle = 0.0;
    public double rootIncrementAngle = 1.0;
    public double rootLevel = 0.0;
    public boolean rootWall = false;
    public boolean growDense = false;
    public boolean cocoa = false;
    public double topLimitUp = 0.0;
    public double topLimitDown = 1.0;
    public double topLimitIncrement = 0.7853981633974483;
    public int genBuffer = 0;
    public float rootDecoRate = 0.0f;
    public IBlockState decoUp = null;
    public IBlockState decoDown = null;

    public AbstractTreeType(World world, IBlockState wood, IBlockState branch, IBlockState leaf) {
        this.random = new Random();
        this.canGrowOn.add(Blocks.field_150346_d);
        this.canGrowOn.add((Block)Blocks.field_150349_c);
        this.canGrowOn.add(Block.func_149684_b((String)"dirt0decoStatic"));
        this.wood = wood;
        this.branch = branch;
        this.leaf = leaf;
    }

    public AbstractTreeType setWaterGen(int depth) {
        this.waterGenerate = depth;
        this.canGrowOn.add((Block)Blocks.field_150355_j);
        this.canGrowOn.add((Block)Blocks.field_150354_m);
        this.canGrowOn.add(Blocks.field_150351_n);
        return this;
    }

    public abstract int getBranchesPerNode(double var1, double var3);

    public abstract double getBranchRotation(double var1, double var3);

    public abstract double getBranchSeperation(double var1);

    public abstract double getBranchPitch(double var1);

    public abstract double getLowestBranchRatio();

    public abstract double getBranchLength(double var1, double var3, double var5);

    public abstract double getTrunkHeight(double var1);

    public abstract double getRootLength(double var1);

    public abstract double getTrunkDiameter(double var1);

    public abstract int getTrunkColumnHeight(double var1, double var3, double var5);

    public abstract int getNumRoots(double var1);

    public abstract void doLeafNode(TreeInstance var1, Branch var2, BlockPos var3);

    public static enum LeafStyle {
        BASIC,
        SPRUCE,
        POPLAR;

    }
}

