/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.HashMap;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import wtf.worldgen.trees.types.AbstractTreeType;
import wtf.worldgen.trees.types.AcaciaTree;
import wtf.worldgen.trees.types.BigTree;
import wtf.worldgen.trees.types.DarkOakTree;
import wtf.worldgen.trees.types.JungleGiant;
import wtf.worldgen.trees.types.JungleTree;
import wtf.worldgen.trees.types.RedwoodTree;
import wtf.worldgen.trees.types.SimpleTree;
import wtf.worldgen.trees.types.SwampTree;
import wtf.worldgen.trees.types.Taiga1Tree;
import wtf.worldgen.trees.types.Taiga2Tree;

public class TreeTypeGetter {
    public static HashMap<WorldGenerator, AbstractTreeType> treeTypes = new HashMap();
    static final IBlockState woodOak = Blocks.field_150364_r.func_176223_P();
    static final IBlockState woodSpruce = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
    static final IBlockState woodBirch = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
    static final IBlockState woodJungle = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    static final IBlockState woodAcacia = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA);
    static final IBlockState darkOakBlocks = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
    static final IBlockState leavesOak = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    static final IBlockState leavesSpruce = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    static final IBlockState leavesBirch = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    static final IBlockState leavesJungle = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    static final IBlockState leavesAcacia = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    static final IBlockState leavesDarkOak = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public static AbstractTreeType getTree(World world, WorldGenerator oldTree) {
        if (treeTypes.containsKey(oldTree)) {
            return treeTypes.get(oldTree);
        }
        if (oldTree instanceof WorldGenShrub) {
            treeTypes.put(oldTree, null);
            return null;
        }
        if (oldTree instanceof WorldGenTrees) {
            IBlockState wood = (IBlockState)ObfuscationReflectionHelper.getPrivateValue(WorldGenTrees.class, (Object)((WorldGenTrees)oldTree), (int)4);
            Boolean vines = (Boolean)ObfuscationReflectionHelper.getPrivateValue(WorldGenTrees.class, (Object)((WorldGenTrees)oldTree), (int)3);
            IBlockState leaf = Blocks.field_150362_t.func_176203_a(wood.func_177230_c().func_176201_c(wood));
            if (wood == woodJungle) {
                treeTypes.put(oldTree, new JungleTree(world));
                return new JungleTree(world);
            }
            treeTypes.put(oldTree, new SimpleTree(world, wood, wood, leaf, vines));
            return new SimpleTree(world, wood, wood, leaf, vines);
        }
        if (oldTree instanceof WorldGenMegaPineTree) {
            treeTypes.put(oldTree, new RedwoodTree(world));
            return new RedwoodTree(world);
        }
        if (oldTree instanceof WorldGenCanopyTree) {
            treeTypes.put(oldTree, new DarkOakTree(world));
            return new DarkOakTree(world);
        }
        if (oldTree instanceof WorldGenBigTree) {
            treeTypes.put(oldTree, new BigTree(world, woodOak, woodOak, leavesOak));
            return new BigTree(world, woodOak, woodOak, leavesOak);
        }
        if (oldTree instanceof WorldGenBirchTree) {
            treeTypes.put(oldTree, new SimpleTree(world, woodBirch, woodBirch, leavesBirch, false));
            return new SimpleTree(world, woodBirch, woodBirch, leavesBirch, false);
        }
        if (oldTree instanceof WorldGenMegaJungle) {
            treeTypes.put(oldTree, new JungleGiant(world));
            return new JungleGiant(world);
        }
        if (oldTree instanceof WorldGenMegaPineTree) {
            treeTypes.put(oldTree, new RedwoodTree(world));
            return new RedwoodTree(world);
        }
        if (oldTree instanceof WorldGenSavannaTree) {
            treeTypes.put(oldTree, new AcaciaTree(world));
            return new AcaciaTree(world);
        }
        if (oldTree instanceof WorldGenSwamp) {
            treeTypes.put(oldTree, new SwampTree(world));
            return new SwampTree(world);
        }
        if (oldTree instanceof WorldGenTaiga1) {
            treeTypes.put(oldTree, new Taiga1Tree(world));
            return new Taiga1Tree(world);
        }
        if (oldTree instanceof WorldGenTaiga2) {
            treeTypes.put(oldTree, new Taiga2Tree(world));
            return new Taiga2Tree(world);
        }
        treeTypes.put(oldTree, null);
        return null;
    }
}

