/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import wtf.init.WTFBlocks;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.trees.types.AbstractTreeType;

public class TreeInstance {
    public final Random random;
    public final World world;
    public final BlockPos pos;
    public final double oriX;
    public final double y;
    public final double oriZ;
    public final AbstractTreeType type;
    public final double trunkDiameter;
    public final double trunkRadius;
    public final double trunkHeight;
    public final double rootLevel;
    public final double scale;
    public static SimplexHelper simplex = new SimplexHelper("treeSimplex");
    public final boolean snow;
    public ChunkScan chunkscan;
    private final HashMap<BlockPos, IBlockState> trunkBlocks;
    private final HashMap<BlockPos, IBlockState> leafBlocks;
    private final HashMap<BlockPos, IBlockState> rootBlocks;
    private final HashMap<BlockPos, IBlockState> decoBlocks;
    Block[] groundArray = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, Block.func_149684_b((String)"dirt0decoStatic")};
    public HashSet<Block> groundBlocks = new HashSet<Block>(Arrays.asList(this.groundArray));
    public int airHash = Blocks.field_150350_a.hashCode();

    public TreeInstance(World world, Random random, ChunkScan chunkscan, BlockPos pos, AbstractTreeType tree) {
        this.trunkBlocks = new HashMap();
        this.leafBlocks = new HashMap();
        this.rootBlocks = new HashMap();
        this.decoBlocks = new HashMap();
        this.world = world;
        this.random = random;
        this.pos = pos;
        this.oriX = (double)pos.func_177958_n() + 0.5;
        this.y = pos.func_177956_o();
        this.oriZ = (double)pos.func_177952_p() + 0.5;
        this.snow = BiomeDictionary.isBiomeOfType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
        this.type = tree;
        this.scale = simplex.get2DNoise(world, pos.func_177958_n() / 100, pos.func_177952_p() / 100);
        this.trunkHeight = tree.getTrunkHeight(this.scale);
        this.trunkDiameter = tree.getTrunkDiameter(this.scale);
        this.trunkRadius = this.trunkDiameter / 2.0;
        this.rootLevel = !tree.airGenerate ? (tree.rootLevel == 0.0 ? (double)random.nextInt(2) : tree.rootLevel) : tree.airGenHeight;
        this.chunkscan = chunkscan;
    }

    public void setTrunk(BlockPos pos) {
        this.trunkBlocks.put(pos, this.type.wood);
    }

    public void setRoot(BlockPos pos) {
        this.rootBlocks.put(pos, this.type.wood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
        this.chunkscan.setGenerated(pos);
    }

    public void setBranch(BlockPos pos, BlockLog.EnumAxis axis) {
        this.rootBlocks.put(pos, this.type.branch.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
        this.chunkscan.setGenerated(pos);
    }

    public void setLeaf(BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().hashCode() == this.airHash) {
            this.leafBlocks.put(pos, this.type.leaf.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
            if (this.snow) {
                this.setDeco(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                if (this.random.nextInt(100) < 0) {
                    this.setDeco(pos.func_177977_b(), WTFBlocks.icicle.func_176223_P());
                }
            }
        }
    }

    public void setDeco(BlockPos pos, IBlockState state) {
        this.decoBlocks.put(pos, state);
    }

    public void setBlocksForPlacement(GeneratorMethods gen) {
        HashMap<BlockPos, IBlockState> masterMap = new HashMap<BlockPos, IBlockState>();
        masterMap.putAll(this.decoBlocks);
        masterMap.putAll(this.leafBlocks);
        masterMap.putAll(this.rootBlocks);
        masterMap.putAll(this.trunkBlocks);
        for (Map.Entry entry : masterMap.entrySet()) {
            gen.setTreeBlock((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
        }
    }

    public boolean inTrunk(BlockPos pos) {
        return this.trunkBlocks.containsKey(pos);
    }
}

