/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.init.BlockSets;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.generators.TreeGenerator;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.components.ColumnTrunk;
import wtf.worldgen.trees.components.Root;
import wtf.worldgen.trees.types.AbstractTreeType;

public class TreeGenMethods {
    private static final float PIx2 = (float)Math.PI * 2;
    private static final float PId4 = 0.7853982f;
    static int airHash = Blocks.field_150350_a.hashCode();
    static Material[] replaceables = new Material[]{Material.field_151579_a, Material.field_151570_A, Material.field_151572_C, Material.field_151577_b, Material.field_151584_j, Material.field_151582_l, Material.field_151585_k, Material.field_151588_w, Material.field_151598_x, Material.field_151578_c, Material.field_151595_p, Material.field_151586_h, Material.field_151597_y};
    protected static HashSet<Material> rootReplaceable = new HashSet<Material>(Arrays.asList(replaceables));

    public static boolean tryGenerate(TreeInstance tree, GeneratorMethods gen) throws Exception {
        if (tree.chunkscan.checkGenerated(tree.pos, (double)tree.type.genBuffer + tree.type.getBranchLength(tree.scale, tree.trunkHeight, tree.trunkHeight * tree.type.getLowestBranchRatio()))) {
            return false;
        }
        if (TreeGenMethods.genTrunk(tree)) {
            float offset = TreeGenMethods.genTop(tree, tree.random.nextFloat() * ((float)Math.PI * 2));
            TreeGenMethods.doBranches(tree, offset);
            TreeGenMethods.genMainRoots(tree);
            tree.setBlocksForPlacement(gen);
            return true;
        }
        return false;
    }

    protected static boolean genTrunk(TreeInstance tree) {
        int startloop = tree.trunkDiameter > 1.0 ? MathHelper.func_76128_c((double)(-tree.trunkRadius)) : 0;
        int finishLoop = MathHelper.func_76143_f((double)tree.trunkRadius);
        boolean canGrow = false;
        for (int loopX = startloop; loopX < finishLoop; ++loopX) {
            for (int loopZ = startloop; loopZ < finishLoop; ++loopZ) {
                double currentRadius = Math.sqrt(loopX * loopX + loopZ * loopZ);
                if (!(tree.trunkRadius <= 1.0) && !(currentRadius <= tree.trunkRadius)) continue;
                double startHeight = tree.y + (double)tree.type.getTrunkColumnHeight(tree.trunkHeight, currentRadius, tree.trunkRadius);
                ColumnTrunk column = new ColumnTrunk(tree.oriX + (double)loopX, tree.oriZ + (double)loopZ, startHeight);
                BlockPos pos = column.currentPos();
                while (BlockSets.nonSolidBlockSet.contains(TreeGenMethods.getBlockState(tree.world, pos).func_177230_c()) && (double)pos.func_177956_o() > tree.y - 4.0) {
                    if (!tree.type.airGenerate || (double)(pos.func_177956_o() - tree.pos.func_177956_o()) > tree.type.airGenHeight) {
                        tree.setTrunk(pos);
                    }
                    pos = column.nextPos();
                }
                if (Math.abs(column.currentY - tree.y) > 2.0) {
                    return false;
                }
                IBlockState surface2 = TreeGenMethods.getBlockState(tree.world, pos);
                if (tree.type.waterGenerate < 1 && tree.world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d()) {
                    return false;
                }
                if (tree.type.canGrowOn.contains(surface2.func_177230_c())) continue;
                return false;
            }
        }
        return true;
    }

    public static float genTop(TreeInstance tree, float offset) {
        if (tree.type.leaftype == AbstractTreeType.LeafStyle.SPRUCE) {
            int crownLoops = 4;
            for (double nodeHeight = tree.trunkHeight - 1.0; nodeHeight < tree.trunkHeight + (double)crownLoops; nodeHeight += 1.0) {
                int branches = tree.type.getBranchesPerNode(0.1, tree.scale);
                for (int loopMultiBranches = 0; loopMultiBranches < branches; ++loopMultiBranches) {
                    float offSetForBranch = offset + (float)Math.PI * 2 / (float)branches * (float)loopMultiBranches;
                    float vecX = MathHelper.func_76134_b((float)offSetForBranch);
                    float vecZ = MathHelper.func_76126_a((float)offSetForBranch);
                    Branch branch = new Branch(tree, tree.oriX, nodeHeight + tree.y, tree.oriZ, vecX, tree.type.getBranchPitch(tree.scale), vecZ, tree.type.getBranchLength(tree.scale, tree.trunkHeight, nodeHeight));
                    TreeGenMethods.genBranch(tree, branch);
                    offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
                }
                offset += 0.7853982f;
            }
        } else {
            for (double topLoop = tree.type.topLimitUp; topLoop < tree.type.topLimitDown; topLoop += tree.type.topLimitIncrement) {
                int branches = tree.type.getBranchesPerNode(0.1, tree.scale);
                offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
                for (int loopMultiBranches = 0; loopMultiBranches < branches; ++loopMultiBranches) {
                    double offSetForBranch = offset + (float)Math.PI * 2 / (float)branches * (float)loopMultiBranches;
                    double sinTop = Math.sin(topLoop);
                    double vecY = Math.cos(topLoop);
                    double vecX = Math.cos(offSetForBranch) * sinTop;
                    double vecZ = Math.sin(offSetForBranch) * sinTop;
                    Branch branch = new Branch(tree, tree.oriX, tree.trunkHeight - 1.0 + tree.y, tree.oriZ, vecX, vecY, vecZ, tree.type.getBranchLength(tree.scale, tree.trunkHeight, tree.trunkHeight));
                    TreeGenMethods.genBranch(tree, branch);
                    offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
                }
            }
        }
        return offset;
    }

    public static void doBranches(TreeInstance tree, float offset) {
        int lowestBranch = MathHelper.func_76128_c((double)(tree.trunkHeight * tree.type.getLowestBranchRatio()));
        for (double nodeHeight = tree.trunkHeight - tree.type.getBranchSeperation(tree.scale); nodeHeight > (double)lowestBranch; nodeHeight -= tree.type.getBranchSeperation(tree.scale)) {
            double bottom = tree.type.getLowestBranchRatio() * tree.trunkHeight;
            double distFromBottom = nodeHeight - bottom;
            double branchSectionLength = tree.trunkHeight - bottom;
            double taper = 1.0 - MathHelper.func_151237_a((double)(distFromBottom / branchSectionLength), (double)0.1, (double)1.0);
            int branches = tree.type.getBranchesPerNode(taper, tree.scale);
            for (int loopMultiBranches = 0; loopMultiBranches < branches; ++loopMultiBranches) {
                float offSetForBranch = offset + (float)Math.PI * 2 / (float)branches * (float)loopMultiBranches;
                float vecX = MathHelper.func_76134_b((float)offSetForBranch);
                float vecZ = MathHelper.func_76126_a((float)offSetForBranch);
                Branch branch = new Branch(tree, tree.oriX, nodeHeight + tree.y, tree.oriZ, vecX, tree.type.getBranchPitch(tree.scale), vecZ, tree.type.getBranchLength(tree.scale, tree.trunkHeight, nodeHeight));
                TreeGenMethods.genBranch(tree, branch);
                offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
            }
            offset += 0.7853982f;
        }
    }

    public static void genMainRoots(TreeInstance tree) {
        double offset = tree.random.nextDouble() * 6.2831854820251465;
        for (double angleDown = tree.type.rootInitialAngle; angleDown > tree.type.rootFinalAngle; angleDown -= tree.type.rootIncrementAngle) {
            int numRoots = tree.type.getNumRoots(tree.trunkDiameter);
            for (int loopMultiBranches = 0; loopMultiBranches < numRoots; ++loopMultiBranches) {
                double offSetForBranch = offset + Math.PI / (double)numRoots * (double)loopMultiBranches;
                double vecY = Math.cos(angleDown);
                double sinY = Math.sin(angleDown);
                double vecX = Math.cos(offSetForBranch) * sinY;
                double vecZ = Math.sin(offSetForBranch) * sinY;
                Root root = new Root(tree, tree.oriX, tree.y + tree.rootLevel + tree.type.airGenHeight, tree.oriZ, vecX, vecY, vecZ, tree.type.getRootLength(tree.trunkHeight));
                while (tree.inTrunk(root.lateralNext())) {
                }
                while (root.hasNext()) {
                    BlockPos pos = root.pos();
                    tree.setRoot(pos);
                    if (tree.type.rootWall) {
                        int loop = 1;
                        while (BlockSets.nonSolidBlockSet.contains(TreeGenMethods.getBlockState(tree.world, pos.func_177979_c(loop)).func_177230_c()) && (double)loop > tree.type.airGenHeight + 1.0) {
                            tree.setRoot(pos.func_177979_c(loop));
                            ++loop;
                        }
                    } else if (tree.random.nextFloat() < tree.type.rootDecoRate) {
                        if (tree.random.nextBoolean()) {
                            BlockPos decoPos = pos.func_177977_b();
                            if (TreeGenMethods.getBlockState(tree.world, decoPos).func_177230_c().hashCode() == airHash) {
                                tree.setDeco(pos.func_177977_b(), tree.type.decoDown);
                            }
                        } else {
                            BlockPos decoPos = pos.func_177984_a();
                            if (TreeGenMethods.getBlockState(tree.world, decoPos).func_177230_c().hashCode() == airHash) {
                                tree.setDeco(pos.func_177984_a(), tree.type.decoUp);
                            }
                        }
                    }
                    if (TreeGenMethods.canReplaceRoot(tree, pos.func_177977_b())) {
                        root.growDown(tree);
                        continue;
                    }
                    if (!tree.groundBlocks.contains(tree.world.func_180495_p(pos.func_177977_b()))) {
                        root.growLateral();
                        continue;
                    }
                    root.next();
                }
                offset += 0.7853981852531433;
            }
        }
    }

    protected static boolean genBranch(TreeInstance tree, Branch branch) {
        while (tree.inTrunk(branch.pos())) {
            branch.next();
        }
        if (tree.type.cocoa && (double)tree.random.nextFloat() < 0.3) {
            TreeGenMethods.genCocoa(tree, branch);
        }
        BlockPos pos = branch.pos();
        while (branch.hasNext()) {
            if (!TreeGenMethods.canReplace(tree, pos)) {
                return false;
            }
            switch (tree.type.leaftype) {
                case BASIC: {
                    tree.setBranch(pos, branch.axis);
                    break;
                }
                case SPRUCE: {
                    double remaining = branch.length - (double)branch.count;
                    tree.type.doLeafNode(tree, branch, pos);
                    break;
                }
            }
            pos = branch.next();
        }
        if (!TreeGenMethods.canReplace(tree, pos)) {
            return false;
        }
        switch (tree.type.leaftype) {
            case BASIC: {
                tree.type.doLeafNode(tree, branch, branch.pos());
                break;
            }
            case SPRUCE: {
                break;
            }
        }
        return true;
    }

    public static void genVine(TreeInstance tree, BlockPos pos, double xloop, double zloop) {
        IBlockState block = null;
        if (Math.abs(xloop) > Math.abs(zloop)) {
            if (xloop > 0.0) {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
                pos = pos.func_177974_f();
            } else {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
                pos = pos.func_177976_e();
            }
        } else if (zloop > 0.0) {
            block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
            pos = pos.func_177968_d();
        } else {
            block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
            pos = pos.func_177978_c();
        }
        for (int loop = tree.random.nextInt(tree.type.vines) + 1; loop > -1 && TreeGenMethods.getBlockState(tree.world, pos.func_177979_c(loop)).func_177230_c().hashCode() == tree.airHash; --loop) {
            tree.setDeco(pos.func_177979_c(loop), block);
        }
    }

    protected static void genCocoa(TreeInstance tree, Branch branch) {
        BlockPos pos = branch.pos().func_177977_b();
        if (Math.abs(branch.vecX) > Math.abs(branch.vecZ)) {
            if (branch.vecX > 0.0) {
                if (tree.inTrunk(pos.func_177976_e())) {
                    tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST));
                }
            } else if (tree.inTrunk(pos.func_177974_f())) {
                tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST));
            }
        } else if (branch.vecZ > 0.0) {
            if (tree.inTrunk(pos.func_177968_d())) {
                tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH));
            }
        } else if (tree.inTrunk(pos.func_177978_c())) {
            tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
        }
    }

    protected static boolean canReplace(TreeInstance tree, BlockPos pos) {
        IBlockState state = TreeGenMethods.getBlockState(tree.world, pos);
        if (BlockSets.treeReplaceableBlocks.contains(TreeGenMethods.getBlockState(tree.world, pos).func_177230_c())) {
            return true;
        }
        return tree.type.growDense && state.func_185904_a().hashCode() == Material.field_151584_j.hashCode();
    }

    protected static boolean canReplaceRoot(TreeInstance tree, BlockPos pos) {
        return rootReplaceable.contains(tree.world.func_180495_p(pos).func_185904_a());
    }

    public static IBlockState getBlockState(World world, BlockPos pos) {
        IBlockState state = TreeGenerator.getTreeMapPos(pos);
        return state == null ? world.func_180495_p(pos) : state;
    }
}

