/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subbiomes;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wtf.config.OverworldGenConfig;
import wtf.utilities.simplex.Simplex;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.subbiomes.SubBiome;

public class BiomeAutumnForest
extends BiomeForest
implements SubBiome {
    private final Biome parentBiome;
    Simplex simplex = new Simplex(17781);
    private static final int[] autumnLeaf = new int[]{0xF2FF00, 0xFFFF00, 0xFFF200, 16770560, 16767232, 0xFFCC00, 0xFFBF00, 16757504, 16754176, 0xFF9900, 16747520, 0xFF8000, 16741120, 0xFF6600, 16734464, 16731392, 0xFF4000, 0xFF3300, 16721408};
    private byte ID = (byte)-1;

    public BiomeAutumnForest(BiomeForest.Type typeIn, Biome.BiomeProperties properties, Biome parentBiome) {
        super(typeIn, properties);
        this.parentBiome = parentBiome;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        int noise = (int)(this.simplex.noise(pos.func_177958_n() / OverworldGenConfig.autumnForestColorScale, pos.func_177952_p() / OverworldGenConfig.autumnForestColorScale) * 9.0 + 9.0);
        return autumnLeaf[noise];
    }

    @Override
    public void resetTopBlock(World world, BlockPos pos) {
    }

    @Override
    public double scale() {
        return OverworldGenConfig.autumnForestSize;
    }

    @Override
    public double freq() {
        return (double)OverworldGenConfig.autumnForestPercent / 100.0;
    }

    @Override
    public Biome getBiome() {
        return this;
    }

    @Override
    public byte getID() {
        if (this.ID == -1) {
            this.ID = (byte)Biome.func_185362_a((Biome)this);
        }
        return this.ID;
    }

    @Override
    public Biome getParentBiome() {
        return this.parentBiome;
    }

    @Override
    public WorldGenerator getTree(ChunkScan chunkscan, Random random) {
        return this.parentBiome.func_150567_a(random);
    }
}

