/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.replacers;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import wtf.utilities.simplex.SimplexHelper;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.CaveTypeRegister;
import wtf.worldgen.caves.types.CaveTypeHell;
import wtf.worldgen.replacers.Replacer;

public class NetherrackReplacer
extends Replacer {
    private static SimplexHelper simplex = new SimplexHelper("NetherrackReplacer");

    public NetherrackReplacer() {
        super(Blocks.field_150424_aL);
    }

    @Override
    public boolean isNonSolidAndReplacement(Chunk chunk, BlockPos pos, GeneratorMethods gen, IBlockState oldState) {
        CaveTypeHell.hellBiome biome = CaveTypeRegister.nether.getSubType(pos);
        switch (biome) {
            case DEADFOREST: {
                break;
            }
            case FIREFOREST: {
                break;
            }
            case FROZEN: {
                break;
            }
            case MUSHROOM: {
                break;
            }
            case NORMAL: {
                break;
            }
        }
        return false;
    }

    private double desertNoise(World world, BlockPos pos) {
        double x = (double)pos.func_177958_n() / 15.0;
        double y = (double)pos.func_177956_o() / 3.0;
        double z = (double)pos.func_177952_p() / 15.0;
        return simplex.get3DNoise(world, x, y, z);
    }
}

