/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.replacers;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import wtf.init.BlockSets;
import wtf.utilities.simplex.SimplexHelper;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.CaveTypeRegister;
import wtf.worldgen.caves.types.CaveTypeHell;
import wtf.worldgen.replacers.Replacer;

public class LavaReplacer
extends Replacer {
    private static SimplexHelper simplex = new SimplexHelper("LavaReplacer");

    public LavaReplacer(Block block) {
        super(block);
    }

    @Override
    public boolean isNonSolidAndReplacement(Chunk chunk, BlockPos pos, GeneratorMethods gen, IBlockState oldState) {
        double n = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.33);
        World world = chunk.func_177412_p();
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            gen.replaceBlock(pos, Blocks.field_150355_j.func_176223_P());
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            if (n < 0.33) {
                return true;
            }
            if (n < 0.66) {
                gen.replaceBlock(pos, Blocks.field_150343_Z.func_176223_P());
                gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
            } else {
                gen.replaceBlock(pos, Blocks.field_150343_Z.func_176223_P());
            }
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            CaveTypeHell.hellBiome netherbiome = CaveTypeRegister.nether.getSubType(pos);
            switch (netherbiome) {
                case DEADFOREST: {
                    break;
                }
                case FIREFOREST: {
                    break;
                }
                case FROZEN: {
                    break;
                }
                case MUSHROOM: {
                    break;
                }
                case NORMAL: {
                    break;
                }
            }
        }
        return false;
    }
}

