/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.generators;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenerator;
import wtf.config.OverworldGenConfig;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.trees.TreeGenMethods;
import wtf.worldgen.trees.TreeInstance;
import wtf.worldgen.trees.TreeTypeGetter;
import wtf.worldgen.trees.types.AbstractTreeType;
import wtf.worldgen.trees.types.Shrub;

public class TreeGenerator {
    private static SimplexHelper treeSimplex = new SimplexHelper("TreeSimplex");
    private static HashMap<BlockPos, IBlockState> worldBlockMap = new HashMap();

    public static synchronized void addTreeMapPos(BlockPos pos, IBlockState state) {
        worldBlockMap.put(pos, state);
    }

    public static synchronized void removeTreeMapPos(BlockPos pos) {
        worldBlockMap.remove(pos);
    }

    public static synchronized IBlockState getTreeMapPos(BlockPos pos) {
        return worldBlockMap.get(pos);
    }

    public static boolean shouldTreePosGenerate(World world, Random random, BlockPos pos) {
        double noise2;
        double noise = treeSimplex.get2DNoise(world, pos.func_177958_n() / 32, pos.func_177952_p() / 32);
        double rand = random.nextFloat();
        return rand < (noise2 = noise - (noise - OverworldGenConfig.treeReplacementRate) * OverworldGenConfig.simplexTreeScale);
    }

    public void generate(World world, ChunkCoords chunkcoords, Random random, ChunkScan chunkscan, GeneratorMethods gen) {
        LinkedList<Shrub> shrubQ = new LinkedList<Shrub>();
        for (int loopx = 0; loopx < 4; ++loopx) {
            for (int loopz = 0; loopz < 4; ++loopz) {
                SurfacePos pos = chunkscan.surface[4 * loopx + random.nextInt(4)][4 * loopz + random.nextInt(4)];
                Biome biome = world.func_180494_b((BlockPos)pos);
                double numTrees = biome.field_76760_I.field_76832_z > -1 ? (double)biome.field_76760_I.field_76832_z : 16.0;
                double genChance = 16.0 * numTrees / 256.0;
                if ((double)random.nextFloat() > genChance || pos.generated || !TreeGenerator.shouldTreePosGenerate(world, random, pos)) continue;
                WorldGenAbstractTree oldTree = biome.func_150567_a(random);
                if (oldTree instanceof WorldGenShrub) {
                    shrubQ.add(new Shrub((WorldGenShrub)oldTree, gen));
                } else if (oldTree == null) continue;
                AbstractTreeType treeType = TreeTypeGetter.getTree(world, (WorldGenerator)oldTree);
                if (treeType == null) continue;
                try {
                    if (!TreeGenMethods.tryGenerate(new TreeInstance(world, random, chunkscan, pos, treeType), gen)) continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        while (!shrubQ.isEmpty()) {
            ((Shrub)shrubQ.poll()).generate(world, random, chunkscan.getRandomNotGenerated(random));
        }
    }
}

