/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import wtf.config.OverworldGenConfig;
import wtf.init.BlockSets;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.GeneratorMethods;

public class SurfaceGenerator {
    private static SimplexHelper simplex = new SimplexHelper("SurfaceGenerator");

    public void generate(World world, ChunkCoords chunkcoords, Random random, ChunkScan chunkscan, GeneratorMethods gen) {
        SurfacePos[][] surfacePosArray = chunkscan.surface;
        int n = surfacePosArray.length;
        for (int i = 0; i < n; ++i) {
            SurfacePos[] posArray;
            for (SurfacePos pos : posArray = surfacePosArray[i]) {
                Biome biome = world.func_180494_b((BlockPos)pos);
                if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                    if (!(simplex.get2DNoise(world, pos.func_177958_n() * 16, pos.func_177952_p() * 16) > OverworldGenConfig.riverFracChunkPercent) || !(simplex.get3DNoise(world, pos) > OverworldGenConfig.riverFracFreq)) continue;
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    continue;
                }
                if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                    if (!(simplex.get2DNoise(world, pos.func_177958_n() * 16, pos.func_177952_p() * 16) > OverworldGenConfig.mountainFracChunkPercent) || !(simplex.get3DNoise(world, pos) > OverworldGenConfig.mountainFracFreq)) continue;
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    continue;
                }
                if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || !(simplex.get2DNoise(world, pos.func_177958_n() * 16, pos.func_177952_p() * 16) > OverworldGenConfig.forestMossChunkPercent) || !(simplex.get3DNoise(world, pos) > OverworldGenConfig.ForestMossFreq)) continue;
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
    }
}

