/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.generators;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.World;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.subbiomes.SubBiome;

public class SubBiomeGenerator {
    public static HashMap<Byte, SubBiome> subBiomeRegistry = new HashMap();
    private static SimplexHelper simplex = new SimplexHelper("SubBiome");

    public void generate(World world, ChunkCoords chunkcoords, Random random, ChunkScan chunkscan, GeneratorMethods gen) {
        byte[] newBiomes = chunkcoords.getChunk(world).func_76605_m();
        for (int xloop = 0; xloop < 16; ++xloop) {
            for (int zloop = 0; zloop < 16; ++zloop) {
                double z;
                double x;
                int loop = xloop + zloop * 16;
                SubBiome sub = subBiomeRegistry.get(newBiomes[loop]);
                if (sub == null || !(simplex.get2DNoise(world, x = (double)(xloop + chunkcoords.getWorldX()) / sub.scale(), z = (double)(zloop + chunkcoords.getWorldZ()) / sub.scale()) < sub.freq())) continue;
                newBiomes[loop] = sub.getID();
            }
        }
    }
}

