/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.dungeoncaves.mob;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.dungeoncaves.DungeonAbstractSimple;

public class DungeonSimpleSpider
extends DungeonAbstractSimple {
    IBlockState block = null;

    public DungeonSimpleSpider(String name) {
        super(name);
        this.genAir = true;
    }

    @Override
    public boolean canGenerateAt(GeneratorMethods gen, CaveListWrapper cave) {
        IBlockState temp = BlockSets.getTransformedState(gen.getWorld().func_180495_p(cave.centerpos.getFloorPos()), BlockSets.Modifier.COBBLE);
        this.block = BlockSets.getTransformedState(temp, BlockSets.Modifier.MOSSY);
        if (this.block == null) {
            this.block = Blocks.field_150341_Y.func_176223_P();
        }
        return this.isHeight(cave, 4);
    }

    @Override
    public void generateCenter(GeneratorMethods gen, Random rand, CavePosition pos, float depth) {
        BlockPos midpos = pos.getMidPos();
        gen.spawnVanillaSpawner(midpos, "Spider", 3);
        midpos = midpos.func_177977_b();
        while (midpos.func_177956_o() > pos.floor) {
            gen.replaceBlock(midpos, Blocks.field_150341_Y.func_176223_P());
            midpos = midpos.func_177977_b();
        }
    }

    @Override
    public void generateAir(GeneratorMethods gen, Random random, BlockPos floating, float depth) {
        double noise = this.simplex.get3DNoise(gen.getWorld(), floating.func_177958_n(), floating.func_177956_o(), floating.func_177952_p());
        if (noise < 0.2) {
            gen.replaceBlock(floating, Blocks.field_150321_G.func_176223_P());
        }
    }

    @Override
    public void generate(GeneratorMethods gen, Random random, BlockPos pos) {
        gen.replaceBlock(pos, this.block);
    }
}

