/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.dungeoncaves.ambient;

import java.util.Random;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.dungeoncaves.AbstractDungeonType;

public class DungeonJungleTemple
extends AbstractDungeonType {
    public DungeonJungleTemple(String name) {
        super(name, 5, 0);
    }

    @Override
    public boolean canGenerateAt(GeneratorMethods gen, CaveListWrapper cave) {
        return this.isHeight(cave, 4) && cave.getAvgFloor() > 36.0;
    }

    @Override
    public void generateCenter(GeneratorMethods gen, Random rand, CavePosition pos, float depth) {
        gen.replaceBlock(pos.getFloorPos(), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        gen.replaceBlock(pos.getFloorPos().func_177977_b(), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        gen.replaceBlock(pos.getFloorPos().func_177984_a(), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        gen.replaceBlock(pos.getFloorPos().func_177981_b(2), Blocks.field_150478_aa.func_176223_P());
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (this.simplex.get3DNoise(gen.getWorld(), pos) < 0.25) {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        } else {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P());
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (this.simplex.get3DNoise(gen.getWorld(), pos) < 0.25) {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        } else {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P());
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (this.simplex.get3DNoise(gen.getWorld(), pos) < 0.25) {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED));
        } else {
            gen.replaceBlock(pos, Blocks.field_150417_aV.func_176223_P());
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextFloat() < depth && gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE)) {
            int loop;
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
            }
        }
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
    }

    @Override
    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
        if (this.simplex.get3DNoise(gen.getWorld(), pos) < 0.15) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }
}

