/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.dungeoncaves;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public abstract class AbstractDungeonType
extends AbstractCaveType {
    protected SimplexHelper simplex;
    private final double variable = 5.0;
    protected BlockPos midpos;
    protected double wallDist;
    protected CaveListWrapper cave = null;

    public AbstractDungeonType(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    public abstract boolean canGenerateAt(GeneratorMethods var1, CaveListWrapper var2);

    protected boolean isHeight(CaveListWrapper cave, int n) {
        return cave.getAvgCeiling() - cave.getAvgFloor() >= (double)n;
    }

    public void setupForGen(CaveListWrapper cave) {
        this.simplex = new SimplexHelper(this.name + cave.centerpos.toString(), false);
        this.cave = cave;
        this.midpos = cave.centerpos.getMidPos();
        this.wallDist = cave.getWallDist(cave.centerpos);
    }

    public boolean shouldPosGen(GeneratorMethods gen, BlockPos pos) {
        int z;
        double rad = this.cave.distFromCenter(pos);
        if (pos.func_177958_n() == this.midpos.func_177958_n() && pos.func_177952_p() == this.midpos.func_177952_p()) {
            return true;
        }
        double vecx = (double)(this.midpos.func_177958_n() - pos.func_177958_n()) / rad;
        double vecy = (double)(this.midpos.func_177956_o() - pos.func_177956_o()) / rad;
        double pitchY = Math.acos(vecy);
        double sinY = Math.sin(pitchY);
        double n = MathHelper.func_151237_a((double)(vecx / sinY), (double)-1.0, (double)1.0);
        double pitchX = Math.acos(n);
        double pitchZ = Math.asin(n);
        double noise = this.simplex.get3DNoise(gen.chunk.func_177412_p(), pitchX * 2.0, pitchY * 3.0, pitchZ * 2.0);
        double maxDist = noise * 5.0 + this.wallDist + 1.0;
        int x = pos.func_177958_n() - this.midpos.func_177958_n();
        return (double)(x * x + (z = pos.func_177952_p() - this.midpos.func_177952_p()) * z) < maxDist * maxDist;
    }

    public abstract void generateCenter(GeneratorMethods var1, Random var2, CavePosition var3, float var4);
}

